% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perturb_stochastic.R
\name{perturb_stochastic}
\alias{perturb_stochastic}
\title{Calculate stochastic elasticities from a time-series of matrix population
models and corresponding population vectors}
\usage{
perturb_stochastic(X_t, u_t)
}
\arguments{
\item{X_t}{A list of matrix population models}

\item{u_t}{A list of corresponding population vectors}
}
\value{
A list of three matrices:
  \item{E}{matrix of stochastic elasticities}
  \item{E_mu}{matrix of stochastic elasticities to mean transition rates}
  \item{E_sigma}{matrix of stochastic elasticities to the variance in
  transition rates}
}
\description{
Calculate stochastic elasticities given a time-series of matrix population
models and corresponding population vectors, using the method described in
Haridas et al. (2009).
}
\examples{
# generate list of random MPMs
N <- 20 # number of years
s <- 3 # matrix dimension
X <- list() # matrix population model at time t
u <- list() # population vector at time t

for (t in 1:N) {
  X[[t]] <- matrix(runif(s^2), nrow = s, ncol = s)
}

# derive corresponding series of population vectors
u <- pop_vectors(X)

# calculate stochastic elasticities
perturb_stochastic(X, u)

}
\references{
Haridas, C. V., Tuljapurkar, S., & Coulson, T. 2009. Estimating
  stochastic elasticities directly from longitudinal data. Ecology Letters,
  12, 806-812. <doi:10.1111/j.1461-0248.2009.01330.x>
}
\seealso{
Other perturbation analysis: 
\code{\link{perturb_matrix}()},
\code{\link{perturb_trans}()},
\code{\link{perturb_vr}()},
\code{\link{pop_vectors}()}
}
\author{
Patrick Barks <patrick.barks@gmail.com>
}
\concept{perturbation analysis}
