\name{MaxStableRF}
\alias{MaxStableRF}
\alias{InitMaxStableRF}
\title{Max-Stable Random Fields}
\description{
  These functions simulate stationary and isotropic max-stable
  random fields with unit Frechet margins.
}
\usage{
MaxStableRF(x, y=NULL, z=NULL, grid, model, param, maxstable,
            method=NULL, n=1, register=0, gridtriple=FALSE)

InitMaxStableRF(x, y=NULL, z=NULL, grid, model, param, maxstable,
               method=NULL, register=0, gridtriple=FALSE)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{matrix of coordinates, or vector of x coordinates}
  \item{y}{vector of y coordinates}
  \item{z}{vector of z coordinates}
  \item{grid}{logical; determines whether the vectors \code{x},
    \code{y}, and \code{z} should be
    interpreted as a grid definition, see Details.}
  \item{model}{string; see \code{\link{CovarianceFct}}, or
    type \code{\link{PrintModelList}()} to get all options;
    interpretation depends on the value of \code{maxstable}}
  \item{param}{parameter vector:
    \code{param=c(mean, variance, nugget, scale,...)};
    the parameters must be given
    in this order; further parameters are to be added in case of a
    parametrised class of covariance functions,
    see \code{\link{CovarianceFct}}}
  \item{maxstable}{string. Either \code{"extremalGauss"} or
    \code{"BooleanFunction"}; see Details.}
  \item{method}{\code{NULL} or string; method used for simulating,
    see \code{\link{RFMethods}}, or
    type \code{\link{PrintMethodList}()} to get all options;
    interpretation depends on the value of \code{maxstable}.}
  \item{n}{number of realisations to generate}
  \item{register}{0:9; place where intermediate calculations are stored;
    the numbers are aliases for 10 internal registers}
  \item{gridtriple}{logical;  if \code{gridtriple==FALSE} ascending
    sequences for the parameters 
    \code{x}, \code{y}, and \code{z} are
    expected; if \code{gridtriple==TRUE} triples of form
    \code{c(start,end,step)} 
    expected; this parameter is used only
    if \code{grid==TRUE}}
}
\details{
  There are two different kinds of models for max-stable processes
  implemented:
  \itemize{
    \item \code{maxstable="extremalGauss"}\cr
    Gaussian random fields are multiplied by independent
    random factors,
    and the maximum is taken. The random factors are such that
    the resulting random field has unit
    Frechet margins; the specification of the random factor
    is uniquely given by the specification of the random
    field. The parameter vector \code{param}, the \code{model},
    and the \code{method} are interpreted
    in the same way as for Gaussian random fields, see
    \code{\link{GaussRF}}.
    
    \item \code{maxstable="BooleanFunction"}\cr
    Deterministic or random, upper semi-continuous
    \eqn{L_1}{L1}-functions are randomly centred and multiplied by
    suitable, independent random factors; the pointwise maximum over all
    these functions yields a max-stable random field.
    The simulation technique is related to the random coin
    method for Gaussian random field simulation,
    see \code{\link{RFMethods}}. Hence, only
    models that are suitable for the random coin method
    are suitable for this technique, see \code{\link{PrintModelList}()}
    for a complete list of suitable covariance models.\cr
    The only value allowed for \code{method} is \code{"max.MPP"} (and
    \code{NULL}),
    see \code{\link{PrintMethodList}()}. In the parameter list
    \code{param} the first two entries, namely \code{mean} and
    \code{variance}, are ignored. If the nugget is positive,
    for each point an additional independent unit Frechet variable
    with scale parameter
    \code{nugget} is involved when building the maximum
    over all functions.
  }
} \value{
  \code{InitMaxStableRF} returns 0 if no error has occured, and
  a positive value if failed.\cr

  \code{MaxStableRF} and \code{\link{DoSimulateRF}} return \code{NULL}
  if an error has occured; otherwise the returned object
  depends on the parameters:\cr
    \code{n==1}:\cr
    * \code{grid==FALSE}.  A vector of simulated values is
    returned (independent of the dimension of the random field)\cr
    * \code{grid==TRUE}.  An array of the dimension of the
    random field is returned.\cr
    
    \code{n>1}:\cr
    * \code{grid==FALSE}.  A matrix is returned.  The columns
    contain the repetitions.\cr
    * \code{grid==TRUE}.  An array of dimension
    \eqn{d+1}{d+1}, where \eqn{d}{d} is the dimension of
    the random field, is returned.  The last
    dimension contains the repetitions.

}
\references{
  Schlather, M. (2001) Models for stationary max-stable
  random fields. \emph{Submitted}.
}
\author{Martin Schlather, \email{Martin.Schlather@uni-bayreuth.de}
  \url{http://www.geo.uni-bayreuth.de/~martin}}
\seealso{
  \code{\link{CovarianceFct}},
  \code{\link{GaussRF}},
  \code{\link{RandomFields}},
  \code{\link{RFMethods}},
  \code{\link{RFparameters}},
  \code{\link{DoSimulateRF}},
.
}
\examples{
 n <- 100
 x <- y <- 1:n
 ms <- MaxStableRF(x, y, grid=TRUE, model="exponen",
                 param=c(0,1,0,40), maxstable="extr")
 image(x,y,ms)
}
\keyword{spatial}%-- one or more ...
