% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_avg_tau.R
\name{compute_avg_tau}
\alias{compute_avg_tau}
\title{Compute Average tau}
\usage{
compute_avg_tau(total_K, n, k)
}
\arguments{
\item{total_K}{a positive integer as the total Kemeny distance of a ranking versus
the input rankings.}

\item{n}{a positive integer for the number of objects in the ranking.}

\item{k}{a positive integer for the number of judges or attributes in the given
ranking problem. This is also the number of input rankings from the problem.}
}
\value{
A numeric of the average tau correlation based on the total Kemeny distance.
}
\description{
Calculates the average tau correlation coefficient defined by Emond and Mason (2002).
The average tau correlation has a one-to-one relationship with total Kemeny distance,
While it is more common, total Kemeny distance may be preferred to avoid rounding error.
}
\references{
Emond, E. J., & Mason, D. W. (2002). A new rank correlation coefficient with
application to the consensus ranking problem. Journal of Multi-Criteria Decision
Analysis, 11(1), 17-28.
}
\keyword{internal}
