% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seed_based_iteration.R
\name{seed_based_iteration}
\alias{seed_based_iteration}
\title{Seed-Based Iteration}
\usage{
seed_based_iteration(eta, omega, input_rkgs)
}
\arguments{
\item{eta}{a subiteration length for intermittent \emph{Subiterative Convergence}. The recommended
values are between 2 and 8. Smaller subiteration lengths result in shorter run-time.}

\item{omega}{a positive integer for the number of repetitions of perturbing
the seed ranking. An \code{omega} value of 1 corresponds to a single application of
\emph{Subiterative Convergence}.}

\item{input_rkgs}{a \code{k} by \code{n} matrix of \code{k} rankings of \code{n}
objects, where each row is a complete ranking. Note that this is a transpose of
matrix used for functions like \code{fur}, \code{sigfur}, \code{rap_greedy_alg},
and \code{subit_convergence}.}
}
\value{
A list containing the consensus ranking (expressed as ordering) and total
Kemeny distance corresponding to the consensus ranking.
}
\description{
\emph{Seed-Based Iteration} is a heuristic-based seed generation used in \emph{SIgFUR}
to iteratively perturb the ranking to improve the consensus ranking.
}
\examples{
## Four input rankings of five objects
eta <- 2
omega <- 10
input_rkgs <- matrix(c(3, 2, 5, 4, 1, 2, 3, 1, 5, 4, 5, 1, 3, 4, 2, 1, 2, 4, 5, 3),
    byrow = FALSE, ncol = 4)
seed_based_iteration(eta, omega, t(input_rkgs)) # Determined seed-based iterations

## Included dataset of 15 input rankings of 50 objects
eta <- 3
omega <- 5
data(data50x15)
input_rkgs <- as.matrix(data50x15[, -1])
seed_based_iteration(eta, omega, t(input_rkgs)) # Determined seed-based iterations

}
\references{
Badal, P. S., & Das, A. (2018). Efficient algorithms using subiterative
convergence for Kemeny ranking problem. Computers & Operations Research, 98, 198-210.
\doi{10.1016/j.cor.2018.06.007}
}
\seealso{
\code{\link{sigfur}}, \code{\link{subit_convergence}}, \code{\link{mean_seed}}
}
