% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_subbasin_map.R
\name{rvn_subbasin_map}
\alias{rvn_subbasin_map}
\title{Plot Continuous Data Using Subbasin Shapefile}
\usage{
rvn_subbasin_map(
  shpfilename,
  subIDcol,
  plot_date,
  cust_data = NULL,
  normalize_data = FALSE,
  invalid_stop = TRUE,
  basins_label = "subID",
  plot_invalid = FALSE
)
}
\arguments{
\item{shpfilename}{filename of shapefile containing HRU polygons, with one column inidicating Raven HRU ID}

\item{subIDcol}{string of subbasin ID column in shapefile}

\item{plot_date}{string of date to plot in custom.data}

\item{cust_data}{custom data set as read in by custom.read, for daily by_subbasin data}

\item{normalize_data}{whether to normalize data by all cust_data (TRUE) or just the data for the given date (FALSE)}

\item{invalid_stop}{whether to stop if invalid basins are found (TRUE) or just continue with a warning (FALSE)}

\item{basins_label}{label to put on basins, one of c('None,'subID','value') to show nothing, subbasinIDs, or actual plotted values}

\item{plot_invalid}{boolean indicating whether to plot invalid basins in grey (currently disabled)}
}
\value{
\item{p1}{ggplot object of subbasin map}
}
\description{
Plots Raven custom output into a subbasin map
}
\details{
Does not currently support discrete data such as land use. Ability to include invalid basins in grey is currently disabled.
}
\examples{

# Raw shapefile sample data
shpfilename <- system.file("extdata","Nith_shapefile_sample.shp",package="RavenR")

# Custom Output data from Raven for Nith basin
cust_file <- system.file("extdata","run1_PRECIP_Daily_Average_BySubbasin.csv",
                         package="RavenR")
cust_data <- rvn_custom_read(cust_file)

subIDcol <- 'subID'        # attribute in shapefile with subbasin IDs
plot_date <- "2003-03-30"  # date for which to plot custom data

# Generate plot object
p1 <- rvn_subbasin_map(shpfilename,subIDcol,plot_date,cust_data, normalize=TRUE)
p1


}
\seealso{
\code{\link{rvn_subbasin_network_plot}} to create network plots
}
\author{
James R. Craig, University of Waterloo

Robert Chlumsky

Genevieve Brown
}
