% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_write_Raven_header.R
\name{rvn_write_Raven_header}
\alias{rvn_write_Raven_header}
\title{Write common Raven file header}
\usage{
rvn_write_Raven_header(
  filename,
  filetype,
  author = NULL,
  creationDate = TRUE,
  textlen = 40
)
}
\arguments{
\item{filename}{Name of the file, with extension}

\item{filetype}{File extension, Encoding, Raven version (e.g. "rvp ASCII Raven 2.9.1")}

\item{author}{Name of file author (optional)}

\item{creationDate}{Bool of whether creation date should be added to header. (default TRUE)}

\item{textlen}{Length of lines (default: 40, used to right-align text)}
}
\value{
TRUE returns TRUE if executed successfully
}
\description{
Writes the common Raven file header to file. All lines are Appended.
}
\examples{
tf <- file.path(tempdir(), 'HogwartsBasin.rvp')
rvn_write_Raven_header(filename = tf,
                    filetype = 'rvp ASCII Raven 2.9.1',
                    author   = 'Harry Potter')

# view file
readLines(tf)

}
\author{
Leland Scantlebury, \email{leland@scantle.com}
}
