% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_hyd_dygraph.R
\name{rvn_hyd_dygraph}
\alias{rvn_hyd_dygraph}
\title{Read in Raven Hydrograph file}
\usage{
rvn_hyd_dygraph(
  hy,
  timezone = "UTC",
  basins = "",
  main = NULL,
  figheight = 400
)
}
\arguments{
\item{hy}{hydrograph data structure generated by \code{\link{rvn_hyd_read}} routine}

\item{timezone}{data timezone; defaults to UTC}

\item{basins}{list of subbasin names from hydrograph file. Each subbasin creates separate dygraph plots}

\item{main}{dygraph title to override the default (applied to all dygraphs)}

\item{figheight}{height of figure, in pixels}
}
\value{
{res}{ a list of plot handles to dygraph plots}
}
\description{
rvn_hyd_dygraph plots modeled vs observed hydrographs when supplied with hydrograph data
structure read using \code{\link{rvn_hyd_read}}
}
\examples{

# read in RavenR sample hydrographs data
hy <- rvn_hydrograph_data

# view contents for subbasin 36 as dyGraph
dyplots <- rvn_hyd_dygraph(hy,basins="Sub36")
dyplots

rvn_hyd_dygraph(hy,basins="Sub36", main="test title")

# view contents for all basins in hydrograph data
rvn_hyd_dygraph(hy)

}
