\name{market.api.query.bitmarket}
\alias{market.api.query.bitmarket}
\title{Send request to bitmarket market API}
\usage{
market.api.query.bitmarket(url, key, secret, req = list(),
  verbose = getOption("Rbitcoin.verbose"))
}
\arguments{
  \item{url}{character with url on which query needs to be
  passed.}

  \item{key}{character API key used in private API calls.}

  \item{secret}{character API secret used in private API
  calls.}

  \item{req}{list of object passed to API: price and amount
  of opening order, id of cancelling order, etc.}

  \item{verbose}{integer. Rbitcoin processing messages,
  print to console if \code{verbose > 0}, each subfunction
  reduce \code{verbose} by 1. If missing then
  \code{getOption("Rbitcoin.verbose")} is used, by default
  \code{0}.}
}
\value{
R object created by fromJSON decoded result from market's
API call.
}
\description{
Send request to bitmarket market API.
}
\note{
Market specific bitmarket \code{method} param should be
provided in \code{req} object.
}
\examples{
\dontrun{
# ticker
market.api.query.bitmarket(url = 'https://www.bitmarket.pl/json/LTCPLN/ticker.json')
# wallet
market.api.query.bitmarket(url = 'https://www.bitmarket.pl/api2/',
                           req = list(method = 'info'),
                           key = '', secret = '')
}
}
\references{
\url{https://www.bitmarket.pl/docs.php?file=api_private.html}
}
\seealso{
\code{\link{market.api.query}}
}

