% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{RblDownload}
\alias{RblDownload}
\title{Download a file from Bloomberg}
\usage{
RblDownload(file, frequency = 60, timeout = 3600, verbose = TRUE)
}
\arguments{
\item{file}{character string representing the file to download}

\item{frequency}{the polling frequency to check if file is available at Bloomberg}

\item{timeout}{the timeout in seconds}

\item{verbose}{logical. Should R report extra information on progress?}
}
\value{
character string. Path to the downloaded file. NULL on failure
}
\description{
Download a generic file from Bloomberg. 
Use \code{\link{RblFiles}} to list the files available at Bloomberg.
If the file is not available yet (i.e. a request file has just been uploaded), the function waits until the response file is there or the timeout is reached
}
\examples{
\dontrun{
# Run RblConnect first

# Build a request file to download the daily closing prices of 
#  EURO STOXX Index from 2005-01-01 to 2015-12-31.
RblRequest <- 
     RblRequestBuilder(
          header = c(FIRMNAME = RblUser(), 
                     PROGRAMNAME = 'gethistory', 
                     DATERANGE = '20050101|20151231'),
          fields = c('PX_LAST'), 
          identifiers = c('SXXE Index')
     )
                                
# Upload the request file
req <- RblUpload(RblRequest)

# Download the response file
out <- RblDownload(req$out)
out
}

}
