% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blpConnect.R
\name{blpConnect}
\alias{blpConnect}
\title{Establish connection to Bloomberg service}
\usage{
blpConnect(host = getOption("blpHost", "localhost"),
  port = getOption("blpPort", 8194L), default = TRUE,
  appName = getOption("blpAppName", NULL))
}
\arguments{
\item{host}{A character option with either a machine name that is
resolvable by DNS, or an IP address. Defaults to
\sQuote{localhost}.}

\item{port}{An integer variable with the connection port. Default
to \code{8194L}.}

\item{default}{A logical indicating whether this connection should
be saved as the default, as opposed to returned to the
user. Default to \code{TRUE}.}

\item{appName}{the name of an application that is authorized
to connect to bpipe. If this is NULL Rblpapi connects to the
Bloomberg API but cannot authenticate with an app name. This requires
the user to authenticate with a user uuid.}
}
\value{
In the \code{default=TRUE} case nothing is returned, and
this connection is automatically used for all future calls which
omit the \code{con} argument. Otherwise a connection object is
returned which is required by all the accessor functions in the
package.
}
\description{
This function connects to the Bloomberg API
}
\details{
For both \code{host} and \code{port} argument, default
values can also be specified via \code{\link{options}} using,
respectively, the named entries \code{blpHost} and
\code{blpConnect}.

If an additional option \code{blpAutoConnect} is set to
\sQuote{TRUE}, a connection is established in the
\code{.onAttach()} function and stored in the package
environment. This effectively frees users from having to
explicitly create such an object.
}
\examples{
\dontrun{
  con <- blpConnect()   # adjust as needed
}
}
\seealso{
Many SAPI and bPipe connections require authentication
via \code{blpAuthenticate} after \code{blpConnect}.
}
\author{
Whit Armstrong and Dirk Eddelbuettel
}
