% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defaults.R
\name{defaultConnection}
\alias{defaultConnection}
\alias{defaultAuthentication}
\title{Return the default connection/authentication objects}
\usage{
defaultConnection()

defaultAuthentication()
}
\description{
These functions return the default connection/authentication objects
from the package environment.  If no default connection/authentication
has been established yet, will return NULL.
In the case of authentication, if using a desktop/workstation
session, NULL will work fine.  If using SAPI/Bpipe, you may need
to use blpAuthenticate() to create an authentication object.
}
\details{
Required arguments can be set via \code{\link{options}}. See
\code{\link{blpConnect}} and \code{\link{blpAuthenticate}} for details.
In addition, if options \code{blpAutoConnect} and/or
\code{blpAutoAuthenticate} are set to \sQuote{TRUE}, a connection and/or
authentication is established in the \code{.onAttach()} function and
stored in the package environment. This effectively frees users from
having to explicitly create such objects. Of course, the user can also
call \code{blpConnect} and/or \code{blpAuthenticate} explicitly and
store the connection/authentication objects. These helper functions
look up the stored connection/authentications object and return them.
In case no connection has been established, an error message is shown.
In case no authentication has been established, NULL is returned.
(NULL is sufficent for Desktop API connections.)
}
\examples{
\dontrun{
  con <- defaultConnection()
  blpid <- defaultAuthentication()
}
}
\author{
Whit Armstrong and Dirk Eddelbuettel
}
