% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleClustering.R
\name{dropTrainSetVars}
\alias{dropTrainSetVars}
\title{Parameters dropping}
\usage{
dropTrainSetVars(dat, VarToDrop)
}
\arguments{
\item{dat}{data.frame containing the features of each prototype associated to a class.}

\item{VarToDrop}{character vector specifying variables to drop from the training set.}
}
\value{
dat data.frame containing the kept features of each prototype associated to a class.
}
\description{
Drop some parameters (columns) in the training set.
}
\details{
dropTrainSetVars drops some parameters (columns) in the training set
}
\examples{

rep <- system.file("extdata", package="RclusTool")
traindir <- file.path(rep, "train_example")

train <- readTrainSet(traindir)
train <- dropTrainSetVars(train, c("Id", "i..ID", "ArrivalTime", "X"))

}
\seealso{
\code{\link{readTrainSet}}
}
\keyword{internal}
