% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KmeansAutoElbow.R
\name{KmeansQuick}
\alias{KmeansQuick}
\title{Quick kmeans clustering}
\usage{
KmeansQuick(features, K)
}
\arguments{
\item{features}{matrix of raw data (point by line).}

\item{K}{number of clusters.}
}
\value{
res.kmeans results obtained from kmeans algorithm.
}
\description{
Perform quick kmeans algorithm for data clustering.
}
\details{
KmeansQuick partition and K number of groups according to kmeans clustering
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
           matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
           matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
           
res <- KmeansQuick(dat, K=3)

plot(dat[,1], dat[,2], type = "p", xlab = "x", ylab = "y", 
	col = res$cluster, main = "K-means clustering")

}
\seealso{
\code{\link{KmeansAutoElbow}}
}
\keyword{internal}
