% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleBuilding.R
\name{createResFolder}
\alias{createResFolder}
\title{Results directories creation}
\usage{
createResFolder(data.sample, dir.name = "", dir.path = "")
}
\arguments{
\item{data.sample}{sample object.}

\item{dir.name}{directory name where to store results.}

\item{dir.path}{path where to create results directory.}
}
\value{
data.sample updated with results directories.
}
\description{
Create results directories for the sample.
}
\details{
createResFolder creates results directories for the sample.
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
tf <- tempfile()
write.table(dat, tf, sep=",", dec=".")

x <- importSample(file.features=tf, dir.save=dirname(tf))

#Already called in importSample 
createResFolder(x, dir.path=dirname(tf))


}
\keyword{internal}
