% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeSpectral.R
\name{spectralClusteringNg}
\alias{spectralClusteringNg}
\title{Spectral clustering}
\usage{
spectralClusteringNg(sim, K)
}
\arguments{
\item{sim}{similarity matrix.}

\item{K}{number of clusters.}
}
\value{
The function returns a list containing:
\item{label}{vector of labels.}
\item{medoids}{matrix of cluster centers in the space of the K first normalized eigenvectors.}
\item{id.med}{vector containing the medoids indices.}
\item{x}{matrix containing, in columns, the eigenvectors of the similarity matrix.}
\item{eigen.val}{vector containing the eigenvalues of the similarity matrix.}
\item{cluster.info}{some statistics on each cluster.}
}
\description{
Perform spectral clustering thanks to a similarity matrix (according to Ng et al., 2002).
}
\details{
spectralClusteringNg returns a partition obtained by spectral clustering (according to Ng et al., 2002)
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
           matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
           matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))

sim <- computeGaussianSimilarity(dat, 1)
res <- spectralClusteringNg(sim, K=3)

plot(dat[,1], dat[,2], type = "p", xlab = "x", ylab = "y", 
col = res$label, main = "Initial features space")
plot(res$x[,2], res$x[,3], type = "p", xlab = "2nd eigenvector", 
ylab = "3rd eigenvector", col = res$label, main = "Spectral embedding")
}
\references{
A. Ng, M. Jordan, Y. Weiss, On spectral clustering: Analysis and an algorithm, Neural Inf. Process. Systems NIPS14 (2002), pp. 849-856.
}
\seealso{
\code{\link{spectralClustering}}
}
\keyword{internal}
