% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supervised.R
\name{computeSupervised}
\alias{computeSupervised}
\title{Supervised classification}
\usage{
computeSupervised(
  data.sample,
  prototypes,
  method.name = "K-NN",
  model = NULL,
  RclusTool.env = initParameters()
)
}
\arguments{
\item{data.sample}{list containing features, profiles and clustering results.}

\item{prototypes}{data.frame containing the features of each prototype associated to a class.}

\item{method.name}{character vector specifying the supervised algorithm to use. Must be 'K-NN' (K-Nearest Neighbor by default), 'MLP' (MultiLayer Perceptron), 'SVM' (Support Vector Machine) or 'RF' (Random Forest).}

\item{model}{option to predict directly from model}

\item{RclusTool.env}{environment in which all global parameters, raw data and results are stored.}
}
\value{
The function returns a list containing:
\item{label}{vector of labels.}
\item{summary}{data.frame containing classes summaries (min, max, sum, average, sd).}
\item{nbItems}{number of observations.}
\item{prototypes}{data.frame containing the features of each prototype associated to a class.}
}
\description{
Perform supervised classification based on the use of a training set.
}
\details{
computeSupervised performs supervised classification based on the use of a training set
}
\examples{

rep <- system.file("extdata", package="RclusTool")
featuresFile <- file.path(rep, "sample_example_features.csv")
features <- read.csv(featuresFile, header = TRUE)
features$ID <- NULL
traindir <- file.path(rep, "train_example")
tf <- tempfile()
write.table(features, tf, sep=",", dec=".")

x <- importSample(file.features=tf, dir.save=dirname(tf))

train <- readTrainSet(traindir)

res <- computeSupervised(x, prototypes=train)

plot(features[,3], features[,4], type = "p", xlab = "x", ylab = "y", 
col = res$label, main = "K-Nearest-Neighbor classification")


}
\seealso{
\code{\link{readTrainSet}}
}
