% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.r
\name{msgpack_unpack}
\alias{msgpack_unpack}
\alias{msgpackUnpack}
\title{'MsgPack' Unpack}
\usage{
msgpack_unpack(message)

msgpackUnpack(message)
}
\arguments{
\item{message}{A raw vector containing the message.}
}
\value{
The message pack object(s) converted into R types.  If more than one object exists in the message, a list of class "msgpack_set" containing the objects is returned.
}
\description{
De-serialize a 'MsgPack' message.  Array is converted into List. Map is converted into Map/Data.frame. Extension types are converted into raw vectors with EXT attribute.  Integers, Floats, Strings, Raw and Nil are converted into Integer, Float, Character, Raw and NULL respectively.
}
\examples{
x <- msgpack_format(1:10)
x_packed <- msgpack_pack(x)
x_unpacked <- msgpack_unpack(x_packed)
x_simplified <- msgpack_simplify(x_unpacked)
}
\seealso{
See examples/tests.r for more examples.
}
