% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LinkNormalization.R
\name{LinkNormalization}
\alias{LinkNormalization}
\title{Link Normalization}
\usage{
LinkNormalization(links, current)
}
\arguments{
\item{links}{character, one or more URLs to Normalize.}

\item{current}{character, The current page URL where links are located}
}
\value{
Vector of normalized urls
}
\description{
To normalize and transform URLs into a canonical form.
}
\examples{

# Normalize a set of links

links<-c("http://www.twitter.com/share?url=http://glofile.com/page.html",
         "/finance/banks/page-2017.html",
         "./section/subscription.php",
         "//section/",
         "www.glofile.com/home/",
         "IndexEn.aspx",
         "glofile.com/sport/foot/page.html",
         "sub.glofile.com/index.php",
         "http://glofile.com/page.html#1",
         "?tags\%5B\%5D=votingrights&amp;sort=popular"
                   )

links<-LinkNormalization(links,"http://glofile.com" )

links


}
\author{
salim khalil
}
