# -*- R -*-
# $RCSfile: connectionMethods.R,v $
# $Date: 2001/08/28 20:31:20 $
# $Revision: 1.1.1.1 $
# Copyright 2001, Timothy H. Keitt
# Licence: GPL
#

#
# Generic method to be subclassed for each implementation
#

dbConnect <- function(dbObj, ...) UseMethod("dbConnect")
#
# dbObj should be generated by an implementation defined function,
# e.g., PgSQL(), which returns a object with an approprite class
# name, e.g., "PostgreSQL" or "MySQL".  The implementation then
# provides a method that actually opens the connection.  The returned
# connection object should inherit from "Rdbi.conn".
#

dbDisconnect <- function(conn) UseMethod("dbDisconnect")
#
# Close connection and free resources
#

dbReconnect <- function(conn) UseMethod("dbReconnect")
#
# The conn object should store the options passed to dbConnect so that
# it can reestablish the connection.
#

dbConnectionInfo <- function(conn) UseMethod("dbConnectionInfo")
#
# Returns a list containing connection information
#

#
# Default methods
#

dbConnect.default <- function(dbObj, ...) {

  stop("Invalid database class")
  
}

dbDisconnect.default <- function(conn) {

  stop("Invalid connection object")

}

dbReconnect.default <- function(conn) {

  stop("Invalid connection object")

}

dbConnectionInfo.default <- function(conn) {

  stop("Invalid connection object")

}

dbReconnect.Rdbi.conn <- function(conn) {

  eval(attr(conn, "library.call"))
  
  return(eval(attr(conn, "connect.call")))

}

print.Rdbi.conn <- function(x, ...)
  print.list.pairs(dbConnectionInfo(x), ...)



