% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rdca_package.R
\name{decline_param}
\alias{decline_param}
\title{Arps decline object}
\usage{
decline_param(
  input_unit = "Field",
  output_unit = "Field",
  fluid = "oil",
  model = "exponential",
  qi = NULL,
  Di = NULL,
  b = NULL,
  Dt = NULL,
  q_abnd = NULL
)
}
\arguments{
\item{input_unit}{a unit system for parameters, a character string either 'SI' or 'Field'}

\item{output_unit}{a unit system for properties, a character string either 'SI' or 'Field'}

\item{fluid}{fluid type, a character string either 'oil' or 'gas'}

\item{model}{decline model, a character string. 'exponential', 'harmonic', 'hyperbolic', and 'modified_hyperbolic' models are currently available}

\item{qi}{Arp's decline parameter, a numeric value. Depending on the 'input_unit', 'fluid' type, and also the decline_time() 'unit' parameter, it has different units. 'm3/day' for gas production in 'SI' unit with daily data, 'm3/month' for gas production in 'SI' unit with monthly data, 'MSCF/day' for gas production in 'Field' unit with daily data, 'MSCF/month' for gas production in 'Field' unit with monthly data, 'm3/day' for oil production in 'SI' unit with daily data, 'm3/month' for oil production in 'SI' unit with monthly data, 'bbl/day' for oil production in 'Field' unit with daily data, and 'bbl/month' for oil production in 'Field' unit with monthly data}

\item{Di}{Arp's nominal decline parameter, a numeric value in '1/day', '1/month', or '1/year' depending on the decline_time() 'unit' parameter}

\item{b}{Arp's decline parameter. It is zero for the 'exponential' model, one for the 'harmonic' model, and a value between zero and one for the 'hyperbolic' model. For unconventional reservoirs, b values more than one are also reported}

\item{Dt}{Arp's "modified_hyperbolic" nominal terminal decline parameter, a numeric value in '1/day', '1/month', or '1/year' depending on the decline_time() 'unit' input}

\item{q_abnd}{abandonment rate, a numeric value defaulted to NULL. If present, the model predicts the time to reach to the abandonment rate and also the estimated ultimate recovery (EUR) till the abandonment time. It has the same unit as 'qi'.}
}
\value{
a list of class 'decline' with all the required parameters for the decline_predict() S3 methods
}
\description{
Create an object of class 'decline'
}
\examples{
decline_param_1 <- decline_param(input_unit = "Field", output_unit = "Field", fluid = "oil",
model = "exponential", qi = 1000, Di = 0.15, b = 0, q_abnd = NULL)

decline_param_1

decline_param_2 <- decline_param(input_unit = "Field", output_unit = "SI", fluid = "oil",
model = "hyperbolic", qi = 15000, Di = 0.1, b = 0.95, q_abnd = 200)

decline_param_2

decline_param_3 <- decline_param(input_unit = "Field", output_unit = "Field", fluid = "gas",
model = "modified_hyperbolic", qi = 100000, Di = 0.15, b = 0.85, Dt = 0.005, q_abnd = NULL)

decline_param_3
}
