% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SNOMEDcodelist.R
\name{addInactiveConcepts}
\alias{addInactiveConcepts}
\title{Add inactive concepts to a SNOMEDcodelist or SNOMEDconcept vector}
\usage{
addInactiveConcepts(x, provenance = 0:3, SNOMED = getSNOMED())
}
\arguments{
\item{x}{SNOMEDcodelist or SNOMEDconcept object}

\item{provenance}{vector of provenance values to use}

\item{SNOMED}{SNOMED environment containing HISTORY and QUERY tables}
}
\value{
SNOMEDcodelist or SNOMEDconcept with linked inactive concepts included
}
\description{
Adds SNOMED concepts linked by the QUERY or HISTORY tables
that are mapped to or descendants of concepts in a SNOMEDcodelist
or a SNOMEDconcept vector. If a SNOMEDcodelist, it is automatically
converted to the 'simple' format (all items enumerated).
}
\details{
It is recommended to use this function to convert a reference
into a codelist for running a query against an electronic health
record database which might contain historic SNOMED CT concepts.
}
\seealso{
Other SNOMEDcodelist functions: 
\code{\link{SNOMEDcodelist}()},
\code{\link{expandSNOMED}()},
\code{\link{export}()},
\code{\link{is.SNOMEDcodelist}()},
\code{\link{print.SNOMEDcodelist}()}
}
\concept{SNOMEDcodelist functions}
