% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_MDS.R
\name{do.mds}
\alias{do.mds}
\title{(Classical) Multidimensional Scaling}
\usage{
do.mds(X, ndim = 2, preprocess = "center")
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an option for preprocessing the data. This supports three methods,
``center'',``decorrelate'', or ``whiten''. See also \code{\link{aux.preprocess}}
for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
\code{do.mds} performs a classical Multidimensional Scaling (MDS) using
\code{Rcpp} and \code{RcppArmadillo} package to achieve faster performance than
\code{\link[stats]{cmdscale}}.
}
\examples{
# generate data
X <- rbind(matrix(rnorm(100),nr=10),matrix(rnorm(100),nr=10)+10)

## 1. projection onto 2 dimension.
output <- do.mds(X,ndim=2)
plot(output$Y[,1],output$Y[,2])

## 2. different preprocessing leads to different results
output2 <- do.mds(X,ndim=2,preprocess="decorrelate")
output3 <- do.mds(X,ndim=2,preprocess="whiten")
par(mfrow=c(1,3))
plot(output$Y[,1],output$Y[,2],main="center")
plot(output2$Y[,1],output2$Y[,2],main="decorrelate")
plot(output3$Y[,1],output3$Y[,2],main="whiten")

}
\references{
\insertRef{kruskal_multidimensional_1964}{Rdimtools}
}
\author{
Kisung You
}
