% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_MMSD.R
\name{do.mmsd}
\alias{do.mmsd}
\title{Multiple Maximum Scatter Difference}
\usage{
do.mmsd(X, label, ndim = 2, preprocess = c("center", "whiten",
  "decorrelate"), C = 1)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center" and other options of "decorrelate" and "whiten"
are supported. See also \code{\link{aux.preprocess}} for more details.}

\item{C}{nonnegative balancing parameter for intra- and inter-class scatter.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Multiple Maximum Scatter Difference (MMSD) is a supervised linear dimension reduction method.
It is a variant of MSD in that discriminant vectors are orthonormal. Similar to MSD, it also does not suffer from
rank deficiency issue of scatter matrix.
}
\examples{
\dontrun{
## generate data of 3 types with clear difference
dt1  = aux.gensamples(n=33)-100
dt2  = aux.gensamples(n=33)
dt3  = aux.gensamples(n=33)+100

## merge the data and create a label correspondingly
X      = rbind(dt1,dt2,dt3)
label  = c(rep(1,33), rep(2,33), rep(3,33))

## try different balancing parameter
out1 = do.mmsd(X, label, C=0.01)
out2 = do.mmsd(X, label, C=1)
out3 = do.mmsd(X, label, C=100)

## visualize
par(mfrow=c(1,3))
plot(out1$Y[,1], out1$Y[,2], main="MMSD::C=0.01")
plot(out2$Y[,1], out2$Y[,2], main="MMSD::C=1")
plot(out3$Y[,1], out3$Y[,2], main="MMSD::C=100")
}

}
\references{
\insertRef{fengxi_song_multiple_2007}{Rdimtools}
}
\author{
Kisung You
}
