% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_FASTMAP.R
\name{do.fastmap}
\alias{do.fastmap}
\title{FastMap}
\usage{
do.fastmap(X, ndim = 2, preprocess = c("null", "center", "scale",
  "cscale", "whiten", "decorrelate"))
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "null". See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
\code{do.fastmap} is an implementation of \emph{FastMap} algorithm. Though
it shares similarities with MDS, it is innately a nonlinear method that iteratively updates
the projection information using pairwise distance information.
}
\examples{
\dontrun{
## load iris data
data(iris)
X <- as.matrix(iris[,1:4])

## let's compare with other methods
out1 <- do.pca(X, ndim=2)      # PCA
out2 <- do.mds(X, ndim=2)      # Classical MDS
out3 <- do.fastmap(X, ndim=2)  # FastMap

## visualize
par(mfrow=c(1,3))
plot(out1$Y[,1], out1$Y[,2], main="PCA")
plot(out2$Y[,1], out2$Y[,2], main="MDS")
plot(out3$Y[,1], out3$Y[,2], main="FastMap")
}

}
\references{
\insertRef{faloutsos_fastmap:_1995}{Rdimtools}
}
\author{
Kisung You
}
