% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_UDP.R
\name{do.udp}
\alias{do.udp}
\title{Unsupervised Discriminant Projection}
\usage{
do.udp(X, ndim = 2, type = c("proportion", 0.1),
  preprocess = c("center", "scale", "cscale", "decorrelate", "whiten"))
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
\item{interimdim}{the number of PCA target dimension used in preprocessing.}
}
}
\description{
Unsupervised Discriminant Projection (UDP) aims finding projection that balances local and global scatter.
Even though the name contains the word \emph{Discriminant}, this algorithm is \emph{unsupervised}. The
term there reflects its algorithmic tactic to discriminate distance points not in the neighborhood of each data point.
It performs PCA as intermittent preprocessing for rank singularity issue. Authors clearly mentioned that it is inspired
by Locality Preserving Projection, which minimizes the local scatter only.
}
\examples{
\dontrun{
## generate sample data
X = aux.gensamples(n=200)

## use different connectivity level
out1 <- do.udp(X, type=c("proportion",0.05))
out2 <- do.udp(X, type=c("proportion",0.10))
out3 <- do.udp(X, type=c("proportion",0.25))

## visualize
par(mfrow=c(1,3))
plot(out1$Y[,1],out1$Y[,2],main="connectivity 5\%")
plot(out2$Y[,1],out2$Y[,2],main="connectivity 10\%")
plot(out3$Y[,1],out3$Y[,2],main="connectivity 25\%")
}

}
\references{
\insertRef{yang_globally_2007}{Rdimtools}
}
\seealso{
\code{\link{do.lpp}}
}
\author{
Kisung You
}
