% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v1_linear_ADR.R
\name{do.adr}
\alias{do.adr}
\title{Adaptive Dimension Reduction}
\usage{
do.adr(X, ndim = 2, ...)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{ndim}{an integer-valued target dimension.}

\item{...}{extra parameters including \describe{
\item{maxiter}{maximum number of iterations (default: 100).}
\item{abstol}{absolute tolerance stopping criterion (default: 1e-8).}
}}
}
\value{
a named \code{Rdimtools} S3 object containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{algorithm}{name of the algorithm.}
}
}
\description{
Adaptive Dimension Reduction \insertCite{ding_adaptive_2002}{Rdimtools} iteratively finds the best subspace to perform data clustering. It can be regarded as
one of remedies for clustering in high dimensional space. Eigenvectors of a between-cluster scatter matrix are used
as basis of projection.
}
\examples{
\donttest{
## load iris data
data(iris)
set.seed(100)
subid = sample(1:150,50)
X     = as.matrix(iris[subid,1:4])
label = as.factor(iris[subid,5])

## compare ADR with other methods
outADR = do.adr(X)
outPCA = do.pca(X)
outLDA = do.lda(X, label)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(outADR$Y, col=label, pch=19, main="ADR")
plot(outPCA$Y, col=label, pch=19, main="PCA")
plot(outLDA$Y, col=label, pch=19, main="LDA")
par(opar)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{do.ldakm}}
}
\concept{linear_methods}
