% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ESW.r
\name{ESW}
\alias{ESW}
\title{ESW - Effective Strip Width (ESW) for line transects}
\usage{
ESW(object, newdata = NULL)
}
\arguments{
\item{object}{An Rdistance model frame or fitted distance function,
normally produced by a call to \code{\link{dfuncEstim}}.}

\item{newdata}{A data frame containing new values for 
covariates at which either
ESW's or EDR's will be computed. If NULL and 
  \code{object} contains covariates, the  
  covariates stored in
  \code{object} are used (like \code{\link{predict.lm}}).
  If not NULL, covariate values in \code{newdata}
  are used. 
  See \bold{Value} section for more information.}
}
\value{
If \code{newdata} is present, the returned value is 
a vector of effective sampling distances for values of the 
covariates in \code{newdata} with length equal to 
the number of rows in \code{newdata}. 
If \code{newdata} is NULL, the returned value is a vector of effective
sampling distances associated with covariate values in \code{object} and has 
the same number of detected groups.  The returned vector 
has measurement units, i.e., \code{object$outputUnits}.
}
\description{
Returns effective strip width (ESW) for 
  line-transect detection functions. 
  See \code{\link{EDR}} is for point transects.
}
\details{
ESW is the area under 
  the scaled distance function between its
  left-truncation limit (\code{obj$w.lo}) and its right-truncation 
  limit (\code{obj$w.hi}). \if{latex}{I.e., 
    \deqn{ESW = \int_{w.lo}^{w.hi} g(x)dx,} 
  where \eqn{g(x)} is the distance
  function scaled so that \eqn{g(x.scl) = g.x.scl}
  and \eqn{w.lo} and \eqn{w.hi} are the lower
  and upper truncation limits.  }
  
  If detection does not decline with distance, 
  the detection function is flat (horizontal), and 
  area under the detection  
  function is  \eqn{g(0)(w.hi - w.lo)}.  
  If, in this case, \eqn{g(0) = 1}, effective sampling distance is 
  the half-width of the surveys, \eqn{(w.hi - w.lo)}
}
\section{Numeric Integration}{
 
Rdistance uses Simpson's composite 1/3 rule to numerically 
integrate under distance functions. The number of points evaluated 
during numerical integration is controlled by 
\code{options(Rdistance_intEvalPts)} (default 101).
Option 'Rdistance_intEvalPts' must be odd because Simpson's rule
requires an even number of intervals (hence, odd number of points). 
Lower values of 'Rdistance_intEvalPts' increase calculation speeds; 
but, decrease accuracy.
'Rdistance_intEvalPts' must be >= 5.  A warning is thrown if 
'Rdistance_intEvalPts' < 29. Empirical tests by the author 
suggest 'Rdistance_intEvalPts' values >= 30 are accurate 
to several decimal points and that all 'Rdistance_intEvalPts' >= 101 produce 
identical results in all but pathological cases.
}

\examples{
data(sparrowDf)
dfunc <- sparrowDf |> dfuncEstim(formula=dist~bare)

ESW(dfunc) # vector length 356 = number of groups
ESW(dfunc, newdata = data.frame(bare = c(30,40))) # vector length 2

}
\seealso{
\code{\link{dfuncEstim}}, \code{\link{EDR}}, 
\code{\link{effectiveDistance}}
}
\keyword{modeling}
