\name{rebib}
\alias{rebib}
\alias{inspect_Rdbib}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Work with bibtex references in Rd documentation}
\description{Work with bibtex references in Rd documentation.}
\usage{
rebib(infile, outfile, \dots)

inspect_Rdbib(rdo, force = FALSE, \dots)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{infile}{name of the Rd file to update, a character string.}
  \item{outfile}{a filename for the updated Rd object.}
  \item{...}{further arguments to be passed to
    \code{\link{get_bibentries}}, see `Details'.}
  \item{rdo}{an Rd object.}
  \item{force}{if TRUE, re-insert previously imported
    references. Otherwise do not change such references.}
}
\details{
  \code{inspect_Rdbib} takes an Rd object and processes the references
  as specified below.

  The user level function is \code{rebib}. It parses the Rd file
  \code{infile}, calls \code{inspect_Rdbib} to process the references,
  and writes the modified Rd object to file \code{outfile}.

  The default Bibtex file is "REFERENCES.bib" in the current working
  directory. Arguments "\dots" can be used to change the name of the bib
  file and its location.  Argument \code{bibfile} can be used to
  overwrite the default name of the bib file.  Argument \code{package}
  can be used to specify that the bib file should be taken from the root
  of the installation directory of package \code{package}, see
  \code{\link{get_bibentries}} for details.

  The following scheme is used by package Rdpack for incorporation of
  bibliographic references from BibTeX files.

  The key for each reference is put in a comment line in the
  references section, as in
  \preformatted{\references{
    \% bibentry: key1

    \% bibentry: key2

    ...
  }
  }
  Each reference is inserted immediately after the comment line
  specifying it and a matching comment line marking its end is
  inserted.


  Before inserting a reference, a check for the matching ending line is
  made, and if such a line is found, the reference is not inserted.
  This means that to add new references it is sufficient to give their
  keys, as described above and run the function again. References that
  are already there will not be duplicated.

  The inserted reference may also be edited, if necessary. As long as
  the two comment lines enclosing it are not removed, the reference will
  not be overwritten by subsequent calls of the functions described
  here.  Any text outside the markers delineating references inserted by
  this mechanism is left unchanged, including references inserted by
  other means.

  To include all references from the bib file, the following line can be
  used:
  \preformatted{\% bibentry:all
  }
  Notice that there is no space after the colon.
  In this case a marker is put after the last reference and the whole
  thing is considered one block.  So, if the end marker is present and
  \code{force} is FALSE, none will will be changed. Otherwise, if
  \code{force} is TRUE, the whole block of references will be removed
  and all references currently in the bib file will be inserted.

  The main purpose of \verb{bibentry:all} is for use in a package
  overview file. The reference section in the file "package-package"
  generated by \code{\link{promptPackageSexpr}} uses this feature (but
  the user still needs to call \code{rebib} to insert the references).

}
\value{
  for \code{inspect_Rdbib}, the modified Rd object.

  \code{rebib} is used mainly for the side effect of creating a file
  with the references updated. It returns the Rd object created by
  parsing and modifying the Rd file.
}
% \references{
% %% ~put references to the literature/web site here ~
% }
\author{Georgi N. Boshnakov}
% \note{
% %%  ~~further notes~~
% }
%
% %% ~Make other sections like Warning with \section{Warning }{....} ~
%
% \seealso{
% %% ~~objects to See Also as \code{\link{help}}, ~~~
% }
\examples{
# update references in all Rd files in the package's 'man' directory
#
# rdnames <- dir(path = "./man", pattern=".*[.]Rd$", full.names=TRUE)
# lapply(rdnames, function(x) rebib(x, package="Rdpack"))
}
\keyword{bibtex}
\keyword{00Main}
\keyword{RdoProgramming}
