\name{insert_ref}
\alias{insert_ref}
\alias{insertRef}
\alias{insert_citeOnly}
\title{Insert bibtex references in Rd and roxygen2 documentation}
\description{

  Package Rdpack provides Rd macros for inserting references and
  citations from bibtex files into R documentation.  Function
  insert_ref() is the workhorse behind this mechanism. The description
  given in this page should be sufficient, for more details see the
  vignette.

}
\usage{
insert_ref(key, package = NULL, \dots, cached_env = NULL)
}
\arguments{
  \item{key}{the bibtex key of the reference, a character string.}
  \item{package}{the package in which to look for the the bibtex file.}
  \item{\dots}{further arguments to pass on to \code{bibtex::read.bib}}
  \item{cached_env}{
    environment, used to avoid repeatedly pasing the bib
    file from scratch, mainly useful by the Rd macros.
  }
}
\details{
  \code{insert_ref} extracts a reference from a bibtex file, converts
  it to Rd format and returns a single string with embedded newline
  characters. It is the workhorse in the provided mechanism but most
  users do not even need to know about \code{insert_ref}.
  
  The documentation of a package using the mechanism provided here
  relies on the Rd macro \verb{\\insertRef}.  The description below
  assumes that \pkg{Rdpack} has been added to file DESCRIPTION, as
  described in \code{\link{Rdpack-package}} and the vignettes.
  
  References can be inserted in documentation using the syntax
  \verb{\\insertRef{key}{package}}, where \verb{key} is the bibtex key
  of the reference and \verb{package} is an R package containing file
  \code{"REFERENCES.bib"} from which the reference should be taken.

  This works in manually written Rd files and in `roxygen2' documentation
  chunks. The references will appear in the place where the macro is put,
  usually in a dedicated references section (\verb{\\references}
  in Rd files, \verb{@references} in roxygen chunks).

  Argument 'package' can be any installed R package, not necessarily the
  one of the documentation object.  This works for
  packages that have \code{"REFERENCES.bib"} in their installation
  directory and for the default packages.
  
  For example, the references in the references section of this help
  page are generated by the following lines in the Rd file:
\preformatted{
    \\insertRef{Rpack:bibtex}{Rdpack}

    \\insertRef{R}{bibtex}
}

  A roxygen2 documentation chunk might look like this:
\preformatted{
    #' @references
    #' \\insertRef{Rpack:bibtex}{Rdpack}
    #'
    #' \\insertRef{R}{bibtex}
}

  The first reference has label \verb{Rpack:bibtex} and is taken from
  file \code{"REFERENCES.bib"} in package \pkg{Rdpack}. The second reference
  is from the file with the same name in package \pkg{bibtex}.
  
  For more details see vignette:
  \code{vignette("Inserting_bibtex_references", package = "Rdpack")}

  The references are processed when the package is built.

  From version 0.6-1 of \pkg{Rdpack}, additional Rd macros are
  available for citations.  They can be used in Rd and
  roxygen2 documentation.

  \code{\\insertCite{key}{package}} cites the key and records it for
  use by \code{\\insertAllCited}, see below. \code{key} can contain
  more keys separated by commas.

  \tabular{ll}{
     \code{\\insertCite{parseRd,Rpack:bibtex}{Rdpack}} \tab \insertCite{parseRd,Rpack:bibtex}{Rdpack} \cr
     \code{\\insertCite{Rpack:bibtex}{Rdpack}}   \tab \insertCite{Rpack:bibtex}{Rdpack} 
  }
  By default the citations are parenthesised
  \insertCite{parseRd}{Rdpack}.  To get textual citations, like
  \insertCite{parseRd;textual}{Rdpack}, put the string \code{;textual}
  at the end of the key. The references in the last two sentences were
  produced with \code{\\insertCite{parseRd}{Rdpack}} and
  \code{\\insertCite{parseRd;textual}{Rdpack}}, respectively.
  This also works with several citations, e.g.
  \cr
    \code{\\insertCite{parseRd,Rpack:bibtex;textual}{Rdpack}}
  produces: \insertCite{parseRd,Rpack:bibtex;textual}{Rdpack}.

  The macro \code{\\insertNoCite{key}{package}} records one or more
  references for \code{\\insertAllCited} but does not cite it. Setting
  \code{key} to \code{*} will include all references from the
  specified package. For example, 
  \code{\\insertNoCite{R}{bibtex}}  and  \code{\\insertNoCite{*}{utils}}
  record the specified references for inclusion by \code{\\insertAllCited}. 

  \code{\\insertAllCited} inserts all references cited with
  \code{\\insertCite} or \code{\\insertNoCite}. Putting this macro
  in the references section will keep it up to date automatically. 
  The Rd section may look something like:
\preformatted{
      \\insertAllCited{}
}
  or in roxygen2, the references chunk might look like this:
\preformatted{
      #' @references
      #'     \\insertAllCited{}
}

To mix the citations with other text, such as \sQuote{see also} and
\sQuote{chapter 3}, write the list of keys as a free text, starting
it with the symbol \code{@} and prefixing each key with it. 
The \code{@} symbol will not appear in the output. For example, the following code
\preformatted{
    \insertCite{@see also @parseRd and @Rpack:bibtex}{Rdpack}

    \insertCite{@see also @parseRd; @Rpack:bibtex}{Rdpack}

    \insertCite{@see also @parseRd and @Rpack:bibtex;textual}{Rdpack}
}
produces:

\tabular{l}{
  \insertCiteOnly{@see also @parseRd and @Rpack:bibtex}{Rdpack} \cr
  \insertCiteOnly{@see also @parseRd; @Rpack:bibtex}{Rdpack} \cr
  \insertCiteOnly{@see also @parseRd and @Rpack:bibtex;textual}{Rdpack}
}
\code{\\insertCiteOnly{key}{package}} is as
\code{\\insertCite} but does not include the key in the list of
references for \code{\\insertAllCited}.




% Provision to add prefixes and suffixes is also envisaged but is currently under testing and  not documented. 
%   \insertCiteOnly{parseRd,Rpack:bibtex;textual}{Rdpack/see also}
% 
%   \insertCiteOnly{parseRd,Rpack:bibtex;textual}{Rdpack/see also/Chapter 3}
% 
%   \insertCiteOnly{parseRd,Rpack:bibtex;textual}{Rdpack//Chapter 3}
% 
%   \insertCiteOnly{parseRd,Rpack:bibtex;textual}{Rdpack//, Chapter 3}


}
\value{
  for \code{insert_ref}, a character string
}
\references{
  For illustrative purposes there are two sets of citation below
  The first set of references is obtained with \code{\\insertRef} for
  each reference: 

  \insertRef{Rpack:bibtex}{Rdpack}

  % \insertRef{R}{bibtex}

    ---- 

  The following references are obtained with a single \code{\\insertAllCited{}}:

     \insertAllCited{}
}
\author{Georgi N. Boshnakov}
\seealso{
  \code{\link{Rdpack-package}} for overview,
  the vignettes
}
% \examples{
% cat(insert_ref("R", package = "bibtex"), sep = "\n")
% }
\keyword{documentation}
\keyword{Rd}
