/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo.builder;

import java.util.ArrayList;
import java.util.List;
import org.drools.core.ActivationListenerFactory;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.BaseNode;
import org.drools.core.common.UpdateContext;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.phreak.AddRemoveRule;
import org.drools.core.reteoo.PathEndNode;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.RuleBuilder;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.WindowNode;
import org.drools.core.reteoo.builder.AccumulateBuilder;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.reteoo.builder.BuildUtils;
import org.drools.core.reteoo.builder.CollectBuilder;
import org.drools.core.reteoo.builder.ConditionalBranchBuilder;
import org.drools.core.reteoo.builder.EntryPointBuilder;
import org.drools.core.reteoo.builder.EvalBuilder;
import org.drools.core.reteoo.builder.ForallBuilder;
import org.drools.core.reteoo.builder.FromBuilder;
import org.drools.core.reteoo.builder.GroupElementBuilder;
import org.drools.core.reteoo.builder.NamedConsequenceBuilder;
import org.drools.core.reteoo.builder.PatternBuilder;
import org.drools.core.reteoo.builder.QueryElementBuilder;
import org.drools.core.reteoo.builder.ReactiveFromBuilder;
import org.drools.core.reteoo.builder.ReteooComponentBuilder;
import org.drools.core.reteoo.builder.TimerBuilder;
import org.drools.core.reteoo.builder.WindowBuilder;
import org.drools.core.reteoo.builder.WindowReferenceBuilder;
import org.drools.core.rule.Collect;
import org.drools.core.rule.ConditionalBranch;
import org.drools.core.rule.EntryPointId;
import org.drools.core.rule.EvalCondition;
import org.drools.core.rule.Forall;
import org.drools.core.rule.From;
import org.drools.core.rule.GroupElement;
import org.drools.core.rule.InvalidPatternException;
import org.drools.core.rule.MultiAccumulate;
import org.drools.core.rule.NamedConsequence;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.QueryElement;
import org.drools.core.rule.SingleAccumulate;
import org.drools.core.rule.WindowDeclaration;
import org.drools.core.rule.WindowReference;
import org.drools.core.rule.constraint.XpathConstraint;
import org.drools.core.time.TemporalDependencyMatrix;
import org.drools.core.time.impl.Timer;
import org.kie.api.conf.EventProcessingOption;

public class ReteooRuleBuilder
implements RuleBuilder {
    protected BuildUtils utils = new BuildUtils();

    public ReteooRuleBuilder() {
        this.utils.addBuilder(GroupElement.class, new GroupElementBuilder());
        this.utils.addBuilder(Pattern.class, new PatternBuilder());
        this.utils.addBuilder(EvalCondition.class, new EvalBuilder());
        this.utils.addBuilder(QueryElement.class, new QueryElementBuilder());
        this.utils.addBuilder(From.class, new FromBuilder());
        this.utils.addBuilder(Collect.class, new CollectBuilder());
        this.utils.addBuilder(SingleAccumulate.class, new AccumulateBuilder());
        this.utils.addBuilder(MultiAccumulate.class, new AccumulateBuilder());
        this.utils.addBuilder(Timer.class, new TimerBuilder());
        this.utils.addBuilder(Forall.class, new ForallBuilder());
        this.utils.addBuilder(EntryPointId.class, new EntryPointBuilder());
        this.utils.addBuilder(WindowReference.class, new WindowReferenceBuilder());
        this.utils.addBuilder(NamedConsequence.class, new NamedConsequenceBuilder());
        this.utils.addBuilder(ConditionalBranch.class, new ConditionalBranchBuilder());
        this.utils.addBuilder(XpathConstraint.class, new ReactiveFromBuilder());
    }

    @Override
    public List<TerminalNode> addRule(RuleImpl rule, InternalKnowledgeBase kBase, ReteooBuilder.IdGenerator idGenerator) throws InvalidPatternException {
        ArrayList<TerminalNode> nodes = new ArrayList<TerminalNode>();
        GroupElement[] subrules = rule.getTransformedLhs(kBase.getConfiguration().getComponentFactory().getLogicTransformerFactory().getLogicTransformer(), kBase.getGlobals());
        for (int i = 0; i < subrules.length; ++i) {
            BuildContext context = new BuildContext(kBase, idGenerator);
            context.setRule(rule);
            if (EventProcessingOption.STREAM.equals((Object)kBase.getConfiguration().getEventProcessingMode())) {
                TemporalDependencyMatrix temporal = this.utils.calculateTemporalDistance(subrules[i]);
                context.setTemporalDistance(temporal);
            }
            if (kBase.getConfiguration().isSequential()) {
                context.setTupleMemoryEnabled(false);
                context.setObjectTypeNodeMemoryEnabled(false);
            } else {
                context.setTupleMemoryEnabled(true);
                context.setObjectTypeNodeMemoryEnabled(true);
            }
            TerminalNode node = this.addSubRule(context, subrules[i], i, rule);
            nodes.add(node);
        }
        return nodes;
    }

    private TerminalNode addSubRule(BuildContext context, GroupElement subrule, int subruleIndex, RuleImpl rule) throws InvalidPatternException {
        context.setSubRule(subrule);
        ReteooComponentBuilder builder = this.utils.getBuilderFor(subrule);
        if (builder.requiresLeftActivation(this.utils, subrule)) {
            this.addInitialFactPattern(subrule);
        }
        builder.build(context, this.utils, subrule);
        if (context.isTerminated()) {
            context.setTerminated(false);
            return (TerminalNode)((Object)context.getLastNode());
        }
        if (context.getKnowledgeBase().getConfiguration().isPhreakEnabled() && rule.getTimer() != null) {
            builder = this.utils.getBuilderFor(Timer.class);
            builder.build(context, this.utils, rule.getTimer());
        }
        ActivationListenerFactory factory = context.getKnowledgeBase().getConfiguration().getActivationListenerFactory(rule.getActivationListener());
        TerminalNode terminal = factory.createActivationListener(context.getNextId(), context.getTupleSource(), rule, subrule, subruleIndex, context, new Object[0]);
        BaseNode baseTerminalNode = (BaseNode)((Object)terminal);
        baseTerminalNode.networkUpdated(new UpdateContext());
        baseTerminalNode.attach(context);
        this.setPathEndNodes(context);
        if (context.getKnowledgeBase().getConfiguration().isPhreakEnabled()) {
            AddRemoveRule.addRule(terminal, context.getWorkingMemories(), context.getKnowledgeBase());
        }
        context.getNodes().add(baseTerminalNode);
        return terminal;
    }

    private void setPathEndNodes(BuildContext context) {
        PathEndNode[] pathEndNodes = context.getPathEndNodes().toArray(new PathEndNode[context.getPathEndNodes().size()]);
        for (int i = 0; i < pathEndNodes.length; ++i) {
            PathEndNode node;
            pathEndNodes[i] = node = context.getPathEndNodes().get(pathEndNodes.length - 1 - i);
            if (node instanceof RightInputAdapterNode && node.getPathEndNodes() != null) {
                PathEndNode[] riaPathEndNodes = new PathEndNode[node.getPathEndNodes().length + i];
                System.arraycopy(pathEndNodes, 0, riaPathEndNodes, 0, i);
                System.arraycopy(node.getPathEndNodes(), 0, riaPathEndNodes, i, node.getPathEndNodes().length);
                node.setPathEndNodes(riaPathEndNodes);
                continue;
            }
            node.setPathEndNodes(pathEndNodes);
        }
    }

    private void addInitialFactPattern(GroupElement subrule) {
        Pattern pattern = new Pattern(0, ClassObjectType.InitialFact_ObjectType);
        subrule.addChild(0, pattern);
    }

    @Override
    public void addEntryPoint(String id, InternalKnowledgeBase kBase, ReteooBuilder.IdGenerator idGenerator) {
        BuildContext context = new BuildContext(kBase, idGenerator);
        EntryPointId ep = new EntryPointId(id);
        ReteooComponentBuilder builder = this.utils.getBuilderFor(ep);
        builder.build(context, this.utils, ep);
    }

    @Override
    public WindowNode addWindowNode(WindowDeclaration window, InternalKnowledgeBase kBase, ReteooBuilder.IdGenerator idGenerator) {
        BuildContext context = new BuildContext(kBase, idGenerator);
        if (kBase.getConfiguration().isSequential()) {
            context.setTupleMemoryEnabled(false);
            context.setObjectTypeNodeMemoryEnabled(false);
        } else {
            context.setTupleMemoryEnabled(true);
            context.setObjectTypeNodeMemoryEnabled(true);
        }
        WindowBuilder builder = WindowBuilder.INSTANCE;
        builder.build(context, this.utils, window);
        return (WindowNode)context.getObjectSource();
    }
}

