% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json_data_model.R
\name{read_json_data_model}
\alias{read_json_data_model}
\title{Read a data model from JSON}
\usage{
read_json_data_model(txt)
}
\arguments{
\item{txt}{a JSON string, URL or file}
}
\description{
Read a data model from JSON
}
\examples{
## Read the model ----
hpo_model <- read_json_data_model(
   system.file("examples/HPO-model.json", package="ReDaMoR")
)
## Confront to data ----
confrontation_report <- confront_data(
   hpo_model,
   path=list.files(
      system.file("examples/HPO-subset", package="ReDaMoR"),
      full.names=TRUE
   ),
   returnData=TRUE
)
}
