% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imperfect_competition.R
\name{stackelberg_solver}
\alias{stackelberg_solver}
\title{Stackelberg Duopoly with numeric solution}
\usage{
stackelberg_solver(cl_0 = 0, cl_1 = 1, cf_0 = 0, cf_1 = 1,
  p0 = 0, p1 = -1, l0 = 0, f0 = 0)
}
\arguments{
\item{cl_0}{intercept of leader's cost function}

\item{cl_1}{linear term's parameter of leader's cost function}

\item{cf_0}{intercept of follower's cost function}

\item{cf_1}{linear term's parameter of follower's cost function}

\item{p0}{intercept of inverse demand function. Defaults to 0.}

\item{p1}{linear term's parameter of inverse demand function. Defaults to -1. Note that it is important to specify it as a negative number, or the demand curve will be upward sloping.}

\item{l0}{Initial guess for leader's output. Defaults to 0. Strongly advised not to set this parameter unless you are very aware of what you're doing.}

\item{f0}{Initial guess for follower's output. Defaults to 0. Strongly advised not to set this parameter unless you are very aware of what you're doing.}
}
\value{
A list with market price, firm output, profits and market share
}
\description{
This function numerically finds the equilibrium in a Stackelberg duopoly model with linear functions. For guaranteed existence of equilibrium, cost parameters should be non-negative.
The general functional form for a function of argument x is \eqn{f(x) = p_0 + p_1 x}. Parameters p refer to the inverse demand function.
The firm indexed by "l" is the leader, and the one indexed by "f" is the follower.
}
\examples{

stackelberg_solver(p0 = 30)

}
\author{
Pedro Cavalcante Oliveira, Department of Economics, Fluminense Federal University
}
