% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MonteCarlo.R
\name{MonteCarlo}
\alias{MonteCarlo}
\title{Monte Carlo simulations}
\usage{
MonteCarlo(
  statistic,
  trend = "positive",
  FUN,
  B = 1000,
  rdist,
  parallel = FALSE,
  numCores = 2,
  seed = NULL,
  Trows,
  Mcols
)
}
\arguments{
\item{statistic}{Observed value of the statistic.}

\item{trend}{A character string indicating if \code{statistic} is greater
under the null \code{"negative"} or not \code{"positive"}.}

\item{FUN}{A function that computes the statistic.}

\item{B}{An integer specifying the number of replicates used in the Monte
Carlo approach.}

\item{rdist}{function that simulates continuous random variables, 
e.g., \code{\link{runif}} (fastest in \code{stats} package), 
\code{\link{rnorm}} or \code{\link{rexp}}.}

\item{parallel}{If \code{TRUE}, then the Monte Carlo algorithm is done in 
parallel. This can give a significant speedup on multicore machines but
only if \code{B} is approximately bigger than 5000 or \code{XM_T} is big.}

\item{numCores}{Allows the user to specify the amount of parallel processes 
to be used if \code{parallel = TRUE}. If \code{NULL}, then the number of
logical cores is automatically detected and all available cores are used.}

\item{seed}{A vector of the same length as the value of \code{samples}. 
Allows the user to specify the seed of each Monte Carlo simulation. 
If \code{NULL}, then no seed is specified.}

\item{Trows, Mcols}{Number of rows and columns respectively, of the desired 
sample \code{rdist}}
}
\value{
Estimated p-value.
}
\description{
This function performs Monte Carlo simulations when needed,
  it is not developed for the use of the user.
}
\author{
Jorge Castillo-Mateo
}
\keyword{internal}
