% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score.test.R
\name{score.test}
\alias{score.test}
\title{Score Test for the Likelihood of the Record Indicators}
\usage{
score.test(
  X,
  record = c("upper", "lower"),
  alternative = c("two.sided", "greater", "less"),
  probabilities = c("different", "equal"),
  simulate.p.value = FALSE,
  B = 1000
)
}
\arguments{
\item{X}{A numeric vector, matrix (or data frame).}

\item{record}{A character string indicating the type of record, 
"upper" or "lower".}

\item{alternative}{A character indicating the alternative hypothesis 
(\code{"two.sided"}, \code{"greater"} or \code{"less"}). 
Different statistics are used in the one-sided and two-sided alternatives
(see Details).}

\item{probabilities}{A character indicating if the alternative hypothesis 
assume all series with \code{"equal"} or \code{"different"} probabilities
of record.}

\item{simulate.p.value}{Logical. Indicates whether to compute p-values by
Monte Carlo simulation.}

\item{B}{An integer specifying the number of replicates used in the Monte 
Carlo estimation.}
}
\value{
A list of class \code{"htest"}  with the following elements:
  \item{statistic}{Value of the  statistic.}
  \item{parameter}{Degrees of freedom of the approximate \eqn{\chi^2} 
    distribution.}
  \item{p.value}{P-value.}
  \item{method}{A character string indicating the type of test.}
  \item{data.name}{A character string giving the name of the data.}
  \item{alternative}{A character string indicating the alternative
    hypothesis.}
}
\description{
This function performs score (or Lagrange multiplier) tests
  for the likelihood of the record indicators \eqn{I_t} to study the 
  hypothesis of the classical record model.
}
\details{
The null hypothesis of the score tests is that in every vector 
  (columns of the matrix \code{X}), the probability of record at 
  time \eqn{t} is \eqn{1/t} as in the classical record model (i.e., 
  sequences of independent and identically distributed realizations), and 
  the alternative depends on the \code{alternative} and \code{probabilities}
  arguments. The probability at time \eqn{t} is any value, but equal in the
  \eqn{M} series if \code{probabilities = "equal"}  or different in the 
  \eqn{M} series if \code{probabilities = "different"}. The alternative 
  hypothesis is more specific in the first case than in the second one.
  Furthermore, the \code{"two.sided"} \code{alternative} is tested with 
  the usual Lagrange multiplier statistic, while the one-sided 
  \code{alternatives} use specific statistics based on scores. 
  (See Cebrián, Castillo-Mateo and Asín (2021) for details on these tests.)

  If \code{alternative = "two.sided" & probabilities = "equal"}, under the
  null, the Lagrange multiplier statistic has an asymptotic \eqn{\chi^2} 
  distribution with \eqn{T-1} degrees of freedom. It has been seen that for
  the approximation to be adequate \eqn{M} should be greater than \eqn{T}. 
  Otherwise, a \code{simulate.p.value} can be computed.
  
  If \code{alternative = "two.sided" & probabilities = "different"}, the 
  asymptotic behavior of the Lagrange multiplier statistic is not 
  fulfilled, but the Monte Carlo approach to simulate the p-value is 
  applied.
  
  If \code{alternative} is one-sided and \code{probabilities = "equal"},
  the statistic of the test is
  \deqn{\mathcal{T} = \sum_{t=2}^T \frac{(t S_t-M)^2}{M(t-1)} I_{\{S_t > M/t\}}.}
  The p-value of this test is estimated with Monte Carlo simulations,
  since the compute the exact distribution of \eqn{\mathcal{T}} is very 
  expensive.   
  
  If \code{alternative} is one-sided and \code{probabilities = "different"},
  the statistic of the test is
  \deqn{\mathcal{S} = \frac{\sum_{t=2}^T t (t S_t - M) / (t - 1)}{\sqrt{M \sum_{t=2}^T t^2 / (t - 1)}},}
  which is asymptotically standarnd normal distributed in \eqn{M}. It is 
  equivalent to the statistic of the weighted number of records 
  \code{\link{N.test}} with weights \eqn{\omega_t = t^2 / (t-1)}  
  \eqn{(t=2,\ldots,T)}.
}
\examples{
set.seed(23)
# two-sided and different probabilities of record, always simulated the p-value
score.test(ZaragozaSeries, probabilities = "different")
# equal probabilities
score.test(ZaragozaSeries, probabilities = "equal")
# equal probabilities with simulated p-value
score.test(ZaragozaSeries, probabilities = "equal", simulate.p.value = TRUE)

# one-sided and different probabilities of record
score.test(ZaragozaSeries, alternative = "greater", probabilities = "different")
# different probabilities with simulated p-value
score.test(ZaragozaSeries, alternative = "greater", probabilities = "different", 
  simulate.p.value = TRUE)
# equal probabilities, always simulated the p-value
score.test(ZaragozaSeries, alternative = "greater", probabilities = "equal")
}
\references{
Cebrián A, Castillo-Mateo J, Asín J (2021).
“Record Tests to detect non stationarity in the tails with an application to climate change.”
Unpublished manuscript.
}
\seealso{
\code{\link{lr.test}}, \code{\link{global.test}}
}
\author{
Jorge Castillo-Mateo
}
