% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_bnds_betac.R
\name{compute_bnds_betac}
\alias{compute_bnds_betac}
\title{Function to compute the bounds on the coefficients of the common regressors.}
\usage{
compute_bnds_betac(
  sample1 = NULL,
  info0,
  values,
  constraint = NULL,
  c_sign0,
  nc_sign0,
  refs0,
  c_var,
  nc_var,
  sam0,
  info1 = NULL,
  constr = TRUE,
  R2bound = NULL,
  values_sel = NULL
)
}
\arguments{
\item{sample1}{if NULL compute the point estimate, if a natural number then evaluate a bootstrap or subsampling replication.}

\item{info0}{the results of the estimates (point and bootstrap/subsampling replications) for betanc. No default.}

\item{values}{the different unique points of support of the common regressor Xc.}

\item{constraint}{a vector indicating the different constraints in a vector of the size of X_c indicating the type of constraints, if any on f(X_c) : "concave", "concave", "nondecreasing", "nonincreasing", "nondecreasing_convex", "nondecreasing_concave",  "nonincreasing_convex", "nonincreasing_concave", or NULL for none. Default is NULL, no contraints at all.#'}

\item{c_sign0}{sign restrictions on the commonly observed regressors: -1 for a minus sign, 1 for a plus sign, 0 otherwise. Default is NULL, i.e. no constraints.}

\item{nc_sign0}{sign restrictions on the non-commonly observed regressors Xnc: -1 for a minus sign, 1 for a plus sign, 0 otherwise. Default is NULL, i.e. no constraints.}

\item{refs0}{indicating the positions in the vector values corresponding to the components of betac.}

\item{c_var}{label of the commonly observed regressors Xc.}

\item{nc_var}{label of the non commonly observed regressors Xnc.}

\item{sam0}{the directions q where the radial function has been computed.}

\item{info1}{the results of the point estimates for betac. Default is NULL.}

\item{constr}{if sign constraints imposed. Default is TRUE.}

\item{R2bound}{the lower bound on the R2 of the long regression if any. Default is NULL.}

\item{values_sel}{the selected values of Xc for the conditioning. Default is NULL.}
}
\value{
a matrix containing the bounds on the coefficients associated to the common regressor.
}
\description{
Function to compute the bounds on the coefficients of the common regressors.
}
