% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iter_matrix.R
\name{iter_matrix}
\alias{iter_matrix}
\title{Genetic algorithm for generating correlated binary data}
\usage{
iter_matrix(X0, R, T = 1000, e.min = 1e-04, plt = TRUE, perc = TRUE)
}
\arguments{
\item{X0}{Start matrix with specified marginal probabilities. Can
be generated by \code{\link{start_matrix}}.}

\item{R}{Desired correlation matrix the data should have after
running the genetic algorithm.}

\item{T}{Maximum number of iterations after which the genetic
algorithm stops.}

\item{e.min}{Minimum error (RMSE) between the correlation of the
iterated data matrix and R.}

\item{plt}{Boolean parameter that indicates whether to plot
e.min versus the iteration step.}

\item{perc}{Boolean parameter that indicates whether to print the
percentage of iteration steps relativ to T.}
}
\value{
A list with four entries:
 \describe{
\item{\emph{Xt}}{Final representativ data matrix with specified marginal probabilities and a correlation as close as possible to R}
\item{\emph{t}}{Number of performed iteration steps (t <= T)}
\item{\emph{Rt}}{Empirical correlation matrix of Xt}
\item{\emph{RMSE}}{Final RSME error between desired and achieved correlation matrix }
}
}
\description{
Starts the genetic algorithm based on a start matrix with
specified marginal probabilities.
}
\details{
In each step, the genetic algorithm swaps two randomly selected
entries in each column of X0. Thus it can be guaranteed that the
marginal probabilities do not change. If the correlation matrix is closer to R than that of x0(t-1), X0(t) replaces X0(t-1).
}
\examples{
### Generation of the representive matrix Xt
X0 <- start_matrix(p = c(0.5, 0.6), k = 1000)
Xt <- iter_matrix(X0, R = diag(2), T = 10000, e.min = 0.00001)$Xt

### Drawing of a random sample S of size n = 10
S <- Xt[sample(1:1000, 10, replace = TRUE),]
}
\references{
Kruppa, J., Lepenies, B., & Jung, K. (2018). A genetic algorithm for simulating correlated binary data from biomedical research. \emph{Computers in biology and medicine}, \strong{92}, 1-8. \doi{10.1016/j.compbiomed.2017.10.023}
}
\seealso{
For more information, please refer to the package's documentation and the tutorial: \url{https://software.klausjung-lab.de/}.
}
\author{
Jochen Kruppa, Klaus Jung
}
