% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmvbinary_EP.R
\name{rmvbinary_EP}
\alias{rmvbinary_EP}
\title{Simulating correlated binary variables using the algorithm
  by Emrich and Piedmonte (1991)}
\usage{
rmvbinary_EP(n, R, p)
}
\arguments{
\item{n}{Sample size}

\item{R}{Correlation matrix}

\item{p}{Vector of marginal probabilities}
}
\value{
Sample (n x p)-matrix with representing a random sample of size n from the specified multivariate binary distribution.
}
\description{
Generation of random sample of binary correlated variables
}
\details{
The function implements the algorithm proposed by Emrich and
Piedmonte (1991) to generate a random sample of d (=length(p))
correlated binary variables. The sample is generated based on
given marginal probabilities p of the d variables and their
correlation matrix R. The algorithm generates first determines an
appropriate correlation matrix R' for the multivariate normal
distribution. Next, a sample is drawn from N_d(0, R') and each
variable is finnaly dichotomized with respect to p.
}
\examples{
## Generation of a random sample
rmvbinary_EP(n = 10, R = diag(2), p = c(0.5, 0.6))
}
\references{
Emrich, L.J., Piedmonte, M.R. (1991) A method for generating highdimensional multivariate binary variates. \emph{The American Statistician}, \strong{45(4)}, 302. \doi{10.1080/00031305.1991.10475828}
}
\seealso{
For more information, please refer to the package's documentation and the tutorial: \url{https://software.klausjung-lab.de/}.
}
\author{
Jochen Kruppa, Klaus Jung
}
