#' @title add interactivity on a plot
#'
#' @description add interactivity on elements of a raphael plot.
#' There are three interactive features: popup text when mouse is
#' over an element, execute javascript instructions when clicking
#' the element and  execute javascript instructions when 
#' double-clicking the element.
#' @param fun plot function. See details.
#' @param popup.labels labels to display when mouse is over
#' the elements. A character vector. Length must be 
#' the same than the number of new elements generated by
#' the plot function.
#' @param click.actions events to run when mouse is clicking
#' the elements. A character vector of javascript instructions.
#' Length must be the same than the number of new elements 
#' generated by the plot function. 
#' @param dblclick.actions events to run when mouse is double-clicking
#' the elements. A character vector of javascript instructions.
#' Length must be the same than the number of new elements 
#' generated by the plot function.
#' @param ... arguments for \code{fun}.
#' @examples 
#' #START_TAG_TEST
#' plot_function = function(){
#' head( iris )
#' colorsspec = list( setosa.solid = rgb(153/255, 51/255, 0/255, 1)
#' 	, versicolor.solid = rgb(102/255, 102/255, 51/255, 1)
#'	, virginica.solid = rgb(0/255, 51/255, 102/255, 1)
#'	, setosa.area = rgb(153/255, 51/255, 0/255, 0.5)
#'	, versicolor.area = rgb(102/255, 102/255, 51/255, 0.5)
#'	, virginica.area = rgb(0/255, 51/255, 102/255, 0.5)
#'	)
#' links = list( setosa = "window.open(\"http://en.wikipedia.org/wiki/Iris_(plant)\");"
#'	, versicolor = "window.open(\"http://en.wikipedia.org/wiki/Iris_versicolor\");"
#'	, virginica = "window.open(\"http://en.wikipedia.org/wiki/Iris_virginica\");"
#'	)
#' # init plot
#' with( iris, plot( Sepal.Length, Petal.Length , type = "n" ) )
#' # loop over species
#' sdata = split( iris, iris$Species )
#' for(i in names( sdata ) ){
#'	tempdata = sdata[[i]]
#'	###############
#'	# do some calculations to get, predictions and lower bands (3* se)
#'	lo = loess(Petal.Length~Sepal.Length, data = tempdata )
#'	min.x = min(tempdata$Sepal.Length, na.rm = TRUE)
#'	max.x = max(tempdata$Sepal.Length, na.rm = TRUE)
#'	newdata = data.frame( Sepal.Length = seq( min.x, max.x, length.out = 10 ) )
#'	.pred = predict( lo, newdata = newdata, se = TRUE)
#'	lower = .pred$fit - 3*.pred$se.fit
#'	upper = .pred$fit + 3*.pred$se.fit
#'	coord.x = c( newdata$Sepal.Length
#'		  , rev( newdata$Sepal.Length )
#'		  , NA )
#'	coord.y = c( lower, rev(upper), NA )
#'	# end of calculations
#'	###############
#'	# add interactive elts on polygons
#'	add.plot.interactivity( fun = polygon, x = coord.x , y = coord.y
#'			, col = colorsspec[[paste0( i, ".area")]], border = FALSE
#'			, popup.labels = paste0( i, "\\n", "click on the area")
#'			, click.actions = links[[i]]
#'	)
#'	
#'	lines( newdata$Sepal.Length, .pred$fit, col = colorsspec[[paste0( i, ".solid")]] )
#'	# add interactive elts on points
#'	labs = paste( i, "\\n", rep("double click on the point", nrow(tempdata) ), sep = "" )
#'	actions = paste("alert('", format( tempdata$Petal.Length ), "');")
#'	add.plot.interactivity( fun = points
#' 		, x = tempdata$Sepal.Length , y = tempdata$Petal.Length
#'		, col = colorsspec[[paste0( i, ".solid")]], pch = 16
#'		, popup.labels = labs
#'		, dblclick.actions = actions
#'	)
#' }
#' invisible()
#' }
#' 
#' doc = bsdoc( title = "title" )
#' doc = addPlot( doc, fun = plot_function, width = 8 )
#' pages = writeDoc( doc, file = "interactive_plot/example.html")
#' @example examples/STOP_TAG_TEST.R
#' @seealso \code{\link{bsdoc}}, \code{\link{addPlot.bsdoc}}
#' @export 
add.plot.interactivity = function( fun, popup.labels, click.actions, dblclick.actions, ... ){
	
	
	if( .Device == "RAPHAEL" ) .C("set_tracer_on", (dev.cur()-1L))
	fun(...)
	if( .Device == "RAPHAEL" ) {
		ids = .C("collect_id", (dev.cur()-1L), integer(2))[[2]]
		.C("set_tracer_off", (dev.cur()-1L))
	}
	
	if( .Device != "RAPHAEL" ){
		warning("Current device is not a RAPHAEL device.")
		return(invisible())
	} 
	
	if( any( ids < 0 ) ) {
		warning("Unable to retrieve element identifiers")
		return(invisible())
	}
	ids = seq( ids[1], ids[2], by = 1 )
	
	if( !missing( popup.labels ) ){
		if( !is.character( popup.labels ) ) stop("argument popup.labels must be a character vector")
		if( length( popup.labels ) != length( ids ) ) stop("argument popup.labels must be the same length than plotted elements")
		popup.labels = gsub("\\n", "\n", popup.labels)
		instructs = list( as.integer(ids), as.character( popup.labels ), length( ids ) )
		#.C("add_popup", (dev.cur()-1L), as.integer(ids), as.character( popup.labels ), length( ids ) )

		.C("add_post_commands", (dev.cur()-1L), as.integer(ids), as.character( popup.labels ), length( ids ) )
	}
	
	if( !missing( click.actions ) ){
		if( !is.character( click.actions ) ) stop("argument click.actions must be a character vector")
		if( length( click.actions ) != length( ids ) ) stop("argument click.actions must be the same length than plotted elements")
		click.actions = gsub("\\n", "\n", click.actions)
		.C("add_click", (dev.cur()-1L), as.integer(ids), as.character( click.actions ), length( ids ) )
	}
	
	if( !missing( dblclick.actions ) ){
		if( !is.character( dblclick.actions ) ) stop("argument dblclick.actions must be a character vector")
		if( length( dblclick.actions ) != length( ids ) ) stop("argument dblclick.actions must be the same length than plotted elements")
		dblclick.actions = gsub("\\n", "\n", dblclick.actions)
		.C("add_dblclick", (dev.cur()-1L), as.integer(ids), as.character( dblclick.actions ), length( ids ) )
	}
	
}

