/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.img;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ImageMetaInfo {
    private int height;
    private int width;
    private String mime;

    public ImageMetaInfo(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        this.mime = null;
        this.width = -1;
        this.height = -1;
        try {
            this.getInfo(is);
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public ImageMetaInfo(InputStream is) throws IOException {
        this.mime = null;
        this.width = -1;
        this.height = -1;
        this.getInfo(is);
    }

    public ImageMetaInfo(byte[] bytes) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        this.mime = null;
        this.width = -1;
        this.height = -1;
        try {
            this.getInfo(is);
        }
        finally {
            ((InputStream)is).close();
        }
    }

    private void getInfo(InputStream is) throws IOException {
        int car1 = is.read();
        int car2 = is.read();
        int car3 = is.read();
        if (car1 == 71 && car2 == 73 && car3 == 70) {
            is.skip(3L);
            this.width = this.readInt(is, 2, false);
            this.height = this.readInt(is, 2, false);
            this.mime = "image/gif";
        } else if (car1 == 255 && car2 == 216) {
            while (car3 == 255) {
                int marker = is.read();
                int len = this.readInt(is, 2, true);
                if (marker == 192 || marker == 193 || marker == 194) {
                    is.skip(1L);
                    this.height = this.readInt(is, 2, true);
                    this.width = this.readInt(is, 2, true);
                    this.mime = "image/jpeg";
                    break;
                }
                is.skip(len - 2);
                car3 = is.read();
            }
        } else if (car1 == 137 && car2 == 80 && car3 == 78) {
            is.skip(15L);
            this.width = this.readInt(is, 2, true);
            is.skip(2L);
            this.height = this.readInt(is, 2, true);
            this.mime = "image/png";
        } else if (car1 == 66 && car2 == 77) {
            is.skip(15L);
            this.width = this.readInt(is, 2, false);
            is.skip(2L);
            this.height = this.readInt(is, 2, false);
            this.mime = "image/bmp";
        } else {
            int c4 = is.read();
            if (car1 == 77 && car2 == 77 && car3 == 0 && c4 == 42 || car1 == 73 && car2 == 73 && car3 == 42 && c4 == 0) {
                boolean bigEndian = car1 == 77;
                int ifd = 0;
                ifd = this.readInt(is, 4, bigEndian);
                is.skip(ifd - 8);
                int entries = this.readInt(is, 2, bigEndian);
                int i = 1;
                while (i <= entries) {
                    int valOffset;
                    int tag = this.readInt(is, 2, bigEndian);
                    int fieldType = this.readInt(is, 2, bigEndian);
                    if (fieldType == 3 || fieldType == 8) {
                        valOffset = this.readInt(is, 2, bigEndian);
                        is.skip(2L);
                    } else {
                        valOffset = this.readInt(is, 4, bigEndian);
                    }
                    if (tag == 256) {
                        this.width = valOffset;
                    } else if (tag == 257) {
                        this.height = valOffset;
                    }
                    if (this.width != -1 && this.height != -1) {
                        this.mime = "image/tiff";
                        break;
                    }
                    ++i;
                }
            }
        }
        if (this.mime == null) {
            throw new IOException("Unsupported image type");
        }
    }

    private int readInt(InputStream inputStream, int n_bytes, boolean big_endian) throws IOException {
        int out = 0;
        int sv = big_endian ? (n_bytes - 1) * 8 : 0;
        int cnt = big_endian ? -8 : 8;
        int i = 0;
        while (i < n_bytes) {
            out |= inputStream.read() << sv;
            sv += cnt;
            ++i;
        }
        return out;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public String getMime() {
        return this.mime;
    }

    public void setMime(String mime) {
        this.mime = mime;
    }
}

