% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/addSlide.pptx.R
\name{addSlide.pptx}
\alias{addSlide.pptx}
\title{Insert a slide into a pptx object}
\usage{
\method{addSlide}{pptx}(doc, slide.layout, bookmark, ...)
}
\arguments{
\item{doc}{\code{\link{pptx}} object where slide has to be added}

\item{slide.layout}{layout name of the slide to create. See \code{\link{slide.layouts.pptx}}}

\item{bookmark}{\code{"integer"} page number to specify where slide has to be replaced with a new empty one.}

\item{...}{further arguments, not used.}
}
\value{
an object of class \code{\link{pptx}}.
}
\description{
Add a slide into a \code{\link{pptx}} object.
}
\details{
This function is a key function ; if no slide has been added into the document object
no content (tables, plots, images, text) can be added.

If creating a slide of type "Title and Content", only one content can be added because there is only one content shape in the layout.
If creating a slide of type "Two Content", two content can be added because there are 2 content shapes in the layout.

Content shapes are boxes with dotted borders that hold content in its place on a slide layout.
If you need a new layout, create it in PowerPoint :

On the View tab, in the Presentation Views group, click Slide Master.

read \url{http://office.microsoft.com/en-us/powerpoint-help/create-a-new-custom-layout-HA010079650.aspx}

read \url{http://office.microsoft.com/en-us/powerpoint-help/change-a-placeholder-HA010064940.aspx}

Function \code{slide.layouts} returns available layout names of the template used when pptx object has been created.
It is important to know that when using addParagraph.pptx, paragraph and defaut font formats will be defined
by the properties of the shape of the \code{slide.layout} where content will be added.
For example, if you set the shape formatting properties to a 'no bullet', paragraphs of text won't have any bullet.

Also when using addPlot, plot dimensions will be the shape dimensions. It means that if you want to change plot dimensions
, this has to be done in the PowerPoint template used when creating the \code{pptx} object.
}
\note{
The layout names must only contain letters (upper or lower case) from 'a'
to 'z', numbers (from 0 to 9) and spaces.
}
\examples{
\dontrun{
doc.filename = "addSlide_example.pptx"

# set default font size to 24
options( "ReporteRs-fontsize" = 24 )

doc = pptx( title = "title" )

# add a slide with layout "Title Slide"
doc = addSlide( doc, slide.layout = "Title Slide" )
#set the main title
doc = addTitle( doc, "Presentation title" ) 
#set the sub-title
doc = addSubtitle( doc , "This document is generated with ReporteRs.")

# add a slide with layout "Title and Content" then add content
doc = addSlide( doc, slide.layout = "Title and Content" )
doc = addTitle( doc, "Iris sample dataset", level = 1 )
doc = addFlexTable( doc, vanilla.table( iris[ 1:10,] ) )

# add a slide with layout "Two Content" then add content
doc = addSlide( doc, slide.layout = "Two Content" )
doc = addTitle( doc, "Two Content demo", level = 1 )
doc = addFlexTable( doc, vanilla.table( iris[ 46:55,] ) )
doc = addParagraph(doc, "Hello Word!" )

# to see available layouts :
slide.layouts( doc )

# Write the object
writeDoc( doc, file = doc.filename )

# demo slide replacement --------

# define 2 FlexTables
ft1 = vanilla.table( head( mtcars ), add.rownames = TRUE )
ft2 = vanilla.table( head( iris ), add.rownames = TRUE )

# create an doc to be used as template later
mydoc = pptx( )
mydoc = addSlide( mydoc, slide.layout = "Title and Content")
mydoc = addTitle( mydoc, "a table")
mydoc = addFlexTable( mydoc, ft1 )
mydoc = addSlide( mydoc, slide.layout = "Title and Content")
mydoc = addTitle( mydoc, "some text")
mydoc = addParagraph( mydoc, "text example" )
writeDoc( mydoc, "template_example.pptx" )

# use file pp_template_example.pptx as template
# and replace slide 1 
mydoc = pptx(template = "template_example.pptx" )
mydoc = addSlide( mydoc, slide.layout = "Title and Content", bookmark = 1)
mydoc = addTitle( mydoc, "a new table")
mydoc = addFlexTable( mydoc, ft2 )
writeDoc( mydoc, "slide_replacement.pptx" )
}
}
\seealso{
\code{\link{addTitle.pptx}}, \code{\link{slide.layouts}}
, \code{\link{pptx}}, \code{\link{addSlide}}
}

