% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsdoc.R
\name{bsdoc}
\alias{bsdoc}
\title{Create an object representation of a bootstrap html
document}
\usage{
bsdoc(title = "untitled",
  list.definition = getOption("ReporteRs-list-definition"), keywords = "",
  description = "", mathjax = FALSE)
}
\arguments{
\item{title}{\code{"character"} value: title of the document.}

\item{list.definition}{a list definition to specify how ordered and unordered
lists have to be formated. See \code{\link{list.settings}}. Default to
\code{getOption("ReporteRs-list-definition")}.}

\item{keywords}{\code{"character"} value: keywords metadata value to set in the html page}

\item{description}{\code{"character"} value: description metadata value to set in the html page}

\item{mathjax}{\code{logical} value: if \code{TRUE} activate mathjax}
}
\value{
an object of class \code{\link{bsdoc}}.
}
\description{
Create a \code{\link{bsdoc}} object
}
\details{
Several methods can used to send R output into an object of class \code{\link{bsdoc}}.

\itemize{
  \item \code{\link{addTitle.bsdoc}} add titles
  \item \code{\link{addParagraph.bsdoc}} add text
  \item \code{\link{addPlot.bsdoc}} add plots
  \item \code{\link{addFlexTable.bsdoc}} add tables. See \code{\link{FlexTable}}
  \item \code{\link{addImage.bsdoc}} add external images
  \item \code{\link{addRScript.bsdoc}} add highlighted r script
}

Once object has content, user can write the docx into a ".html" file, see \code{\link{writeDoc.bsdoc}}.
}
\note{
\code{bsdoc} objects are deprecated and will be deleted in the next version.
}

