/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.model.datastorage.OpenDoPEHandler;
import org.docx4j.model.sdt.QueryString;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.opendope.XPathsPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.CTDataBinding;
import org.docx4j.wml.CTSdtCell;
import org.docx4j.wml.CTSdtRow;
import org.docx4j.wml.CTSdtText;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.SdtBlock;
import org.docx4j.wml.SdtElement;
import org.docx4j.wml.SdtPr;
import org.docx4j.wml.SdtRun;
import org.docx4j.wml.Tag;
import org.jvnet.jaxb2_commons.ppp.Child;
import org.opendope.xpaths.Xpaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenDoPEReverter {
    private static Logger log = LoggerFactory.getLogger(OpenDoPEReverter.class);
    private WordprocessingMLPackage openDopePkg;
    private WordprocessingMLPackage instancePkg;
    Map<BigInteger, Object> templateConditionSdtsByID = new HashMap<BigInteger, Object>();
    Map<BigInteger, Object> templateRepeatSdtsByID = new HashMap<BigInteger, Object>();
    private TopLevelSdtInstanceFinder instanceSdtPrFinder;

    public OpenDoPEReverter(WordprocessingMLPackage openDopePkg, WordprocessingMLPackage instancePkg) {
        this.openDopePkg = openDopePkg;
        this.instancePkg = instancePkg;
    }

    public boolean revert() throws Docx4JException {
        TopLevelSdtTemplateFinder sdtPrFinder = new TopLevelSdtTemplateFinder(false);
        this.findSdtsInTemplate(this.openDopePkg, sdtPrFinder);
        this.templateConditionSdtsByID = sdtPrFinder.conditionSdtsByID;
        this.templateRepeatSdtsByID = sdtPrFinder.repeatSdtsByID;
        this.handleSdtsInInstance();
        return this.sanityCheck();
    }

    private boolean sanityCheck() throws Docx4JException {
        boolean resultR;
        boolean resultC;
        int expectedConditions = this.templateConditionSdtsByID.size();
        int expectedRepeats = this.templateRepeatSdtsByID.size();
        TopLevelSdtTemplateFinder sdtPrFinder = new TopLevelSdtTemplateFinder(true);
        this.findSdtsInTemplate(this.instancePkg, sdtPrFinder);
        boolean bl = resultC = sdtPrFinder.conditionSdtsByID.size() == expectedConditions;
        if (!resultC) {
            log.error("Restored " + sdtPrFinder.conditionSdtsByID.size() + " condition SDTs but expected " + expectedConditions);
        }
        boolean bl2 = resultR = sdtPrFinder.repeatSdtsByID.size() == expectedRepeats;
        if (!resultR) {
            log.error("Restored " + sdtPrFinder.repeatSdtsByID.size() + " repeat SDTs but expected " + expectedRepeats);
        }
        return resultC && resultR;
    }

    private void findSdtsInTemplate(WordprocessingMLPackage pkg, TopLevelSdtTemplateFinder sdtPrFinder) throws Docx4JException {
        this.findSdtsInTemplatePart(pkg.getMainDocumentPart(), sdtPrFinder);
        RelationshipsPart rp = pkg.getMainDocumentPart().getRelationshipsPart();
        for (Relationship r : rp.getRelationships().getRelationship()) {
            if (r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/header")) {
                this.findSdtsInTemplatePart((HeaderPart)rp.getPart(r), sdtPrFinder);
                continue;
            }
            if (!r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer")) continue;
            this.findSdtsInTemplatePart((FooterPart)rp.getPart(r), sdtPrFinder);
        }
    }

    private void findSdtsInTemplatePart(ContentAccessor content, TopLevelSdtTemplateFinder sdtPrFinder) throws Docx4JException {
        new TraversalUtil(content.getContent(), sdtPrFinder);
    }

    private void handleSdtsInInstance() throws Docx4JException {
        this.handleSdtsInInstancePart(this.instancePkg.getMainDocumentPart());
        RelationshipsPart rp = this.instancePkg.getMainDocumentPart().getRelationshipsPart();
        for (Relationship r : rp.getRelationships().getRelationship()) {
            if (r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/header")) {
                this.handleSdtsInInstancePart((HeaderPart)rp.getPart(r));
                continue;
            }
            if (!r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer")) continue;
            this.handleSdtsInInstancePart((FooterPart)rp.getPart(r));
        }
    }

    private void handleSdtsInInstancePart(ContentAccessor content) throws Docx4JException {
        this.instanceSdtPrFinder = new TopLevelSdtInstanceFinder();
        new TraversalUtil(content.getContent(), this.instanceSdtPrFinder);
        this.replaceConditions();
        this.handleRepeats();
        this.repairBoundSdts();
    }

    private void replaceConditions() {
        for (Object entry : this.instanceSdtPrFinder.sdtsByConditionIDtoReplace) {
            BigInteger key = OpenDoPEHandler.getSdtPr(entry).getId().getVal();
            Object replacement = this.templateConditionSdtsByID.get(key);
            Child child = (Child)entry;
            Object parent = child.getParent();
            log.info("parent: " + parent.getClass().getName());
            if (parent instanceof ContentAccessor || parent instanceof ArrayList) {
                List<Object> list = parent instanceof ContentAccessor ? ((ContentAccessor)parent).getContent() : (ArrayList)parent;
                int index = 0;
                boolean found = false;
                for (Object o : list) {
                    if (XmlUtils.unwrap(o).equals(child)) {
                        found = true;
                        break;
                    }
                    ++index;
                }
                if (found) {
                    list.set(index, replacement);
                    continue;
                }
                log.error("Couldn't find condition sdt: " + key);
                continue;
            }
            log.error("TODO " + parent.getClass().getName());
        }
    }

    private void handleRepeats() {
        for (Object entry : this.instanceSdtPrFinder.repeatSdtToReplace) {
            BigInteger key = OpenDoPEHandler.getSdtPr(entry).getId().getVal();
            Object replacement = this.templateRepeatSdtsByID.get(key);
            if (replacement == null) {
                log.error(OpenDoPEHandler.getSdtPr(entry).getTag().getVal() + " - No replacement SDT with ID " + key.toString());
            }
            Child child = (Child)entry;
            Object parent = child.getParent();
            log.info("parent: " + parent.getClass().getName());
            if (parent instanceof ContentAccessor || parent instanceof ArrayList) {
                List<Object> list = parent instanceof ContentAccessor ? ((ContentAccessor)parent).getContent() : (ArrayList)parent;
                int index = 0;
                boolean found = false;
                for (Object o : list) {
                    if (XmlUtils.unwrap(o).equals(child)) {
                        found = true;
                        break;
                    }
                    ++index;
                }
                if (found) {
                    list.set(index, replacement);
                    continue;
                }
                log.error("Couldn't find repeat sdt: " + key);
                continue;
            }
            log.error("TODO " + parent.getClass().getName());
        }
        for (Object entry : this.instanceSdtPrFinder.repeatSdtToDelete) {
            Child child = (Child)entry;
            Object parent = child.getParent();
            log.info("parent: " + parent.getClass().getName());
            if (parent instanceof ContentAccessor || parent instanceof ArrayList) {
                List<Object> list = parent instanceof ContentAccessor ? ((ContentAccessor)parent).getContent() : (ArrayList)parent;
                int index = 0;
                boolean found = false;
                for (Object o : list) {
                    if (o == null) {
                        log.error(list.getClass().getName() + " contained null entry at index " + index);
                    } else if (XmlUtils.unwrap(o).equals(child)) {
                        found = true;
                        break;
                    }
                    ++index;
                }
                if (found) {
                    list.remove(index);
                    log.debug("removed entry at index " + index);
                    continue;
                }
                log.error("Couldn't find repeat sdt to delete");
                continue;
            }
            log.error("TODO " + parent.getClass().getName());
        }
    }

    private void repairBoundSdts() throws Docx4JException {
        XPathsPart xPathsPart = this.instancePkg.getMainDocumentPart().getXPathsPart();
        if (xPathsPart == null) {
            throw new Docx4JException("OpenDoPE XPaths part missing");
        }
        for (Object entry : this.instanceSdtPrFinder.boundSdtPotentialRepair) {
            SdtElement sdt = (SdtElement)entry;
            SdtPr sdtPr = sdt.getSdtPr();
            if (sdtPr.getDataBinding() != null) continue;
            Tag tag = sdtPr.getTag();
            HashMap<String, String> map = QueryString.parseQueryString(tag.getVal(), true);
            String xpathId = map.get("od:xpath");
            Xpaths.Xpath xp = xPathsPart.getXPathById(xpathId);
            CTDataBinding databinding = Context.getWmlObjectFactory().createCTDataBinding();
            sdtPr.setDataBinding(databinding);
            databinding.setXpath(xp.getDataBinding().getXpath());
            databinding.setPrefixMappings(xp.getDataBinding().getPrefixMappings());
            databinding.setStoreItemID(xp.getDataBinding().getStoreItemID());
            CTSdtText sdttext = Context.getWmlObjectFactory().createCTSdtText();
            sdttext.setMultiLine(true);
            JAXBElement<CTSdtText> sdttextWrapped = Context.getWmlObjectFactory().createSdtPrText(sdttext);
            sdtPr.getRPrOrAliasOrLock().add(sdttextWrapped);
            sdt.getSdtContent().getContent().clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TopLevelSdtInstanceFinder
    extends TraversalUtil.CallbackImpl {
        List<Object> sdtsByConditionIDtoReplace = new ArrayList<Object>();
        List<Object> repeatSdtToReplace = new ArrayList<Object>();
        List<Object> repeatSdtToDelete = new ArrayList<Object>();
        List<Object> boundSdtPotentialRepair = new ArrayList<Object>();
        String previousRepeatID = null;

        private TopLevelSdtInstanceFinder() {
        }

        @Override
        public List<Object> apply(Object o) {
            if (o instanceof SdtBlock || o instanceof SdtRun || o instanceof CTSdtRow || o instanceof CTSdtCell) {
                SdtPr sdtPr = OpenDoPEHandler.getSdtPr(o);
                if (sdtPr != null) {
                    log.debug("Processing " + OpenDoPEHandler.getSdtPr(o).getId().getVal());
                    Tag tag = sdtPr.getTag();
                    if (tag != null) {
                        log.debug(tag.getVal());
                        HashMap<String, String> map = QueryString.parseQueryString(tag.getVal(), true);
                        String conditionId = map.get("od:condition");
                        String resultConditionId = map.get("od:resultConditionFalse");
                        String resultRepeatId = map.get("od:rptd");
                        String resultRptdZeroId = map.get("od:resultRepeatZero");
                        String xpathId = map.get("od:xpath");
                        if (conditionId != null) {
                            this.sdtsByConditionIDtoReplace.add(o);
                            this.previousRepeatID = null;
                        } else if (resultConditionId != null) {
                            this.sdtsByConditionIDtoReplace.add(o);
                            this.previousRepeatID = null;
                        } else if (resultRptdZeroId != null) {
                            this.repeatSdtToReplace.add(o);
                            this.previousRepeatID = null;
                        } else if (resultRepeatId != null) {
                            if (this.previousRepeatID != null && this.previousRepeatID.equals(resultRepeatId)) {
                                this.repeatSdtToDelete.add(o);
                            } else {
                                this.repeatSdtToReplace.add(o);
                            }
                            this.previousRepeatID = resultRepeatId;
                        } else if (xpathId != null) {
                            this.boundSdtPotentialRepair.add(o);
                        } else if (tag.getVal().contains("od:")) {
                            log.info("Ignoring (!) tag: " + tag.getVal());
                        } else {
                            log.debug("Ignoring tag: " + tag.getVal());
                        }
                    }
                }
            } else {
                this.previousRepeatID = null;
            }
            return null;
        }

        @Override
        public boolean shouldTraverse(Object o) {
            return !(o instanceof SdtBlock) && !(o instanceof SdtRun) && !(o instanceof CTSdtRow) && !(o instanceof CTSdtCell);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TopLevelSdtTemplateFinder
    extends TraversalUtil.CallbackImpl {
        private boolean instanceCountOnly;
        Map<BigInteger, Object> conditionSdtsByID = new HashMap<BigInteger, Object>();
        Map<BigInteger, Object> repeatSdtsByID = new HashMap<BigInteger, Object>();

        TopLevelSdtTemplateFinder(boolean instanceCountOnly) {
            this.instanceCountOnly = instanceCountOnly;
        }

        @Override
        public List<Object> apply(Object o) {
            SdtPr sdtPr;
            if ((o instanceof SdtBlock || o instanceof SdtRun || o instanceof CTSdtRow || o instanceof CTSdtCell) && (sdtPr = OpenDoPEHandler.getSdtPr(o)) != null) {
                log.debug("Processing " + OpenDoPEHandler.getSdtPr(o).getId().getVal());
                Tag tag = sdtPr.getTag();
                log.debug(tag.getVal());
                HashMap<String, String> map = QueryString.parseQueryString(tag.getVal(), true);
                String conditionId = map.get("od:condition");
                String repeatId = map.get("od:repeat");
                if (conditionId != null) {
                    this.conditionSdtsByID.put(sdtPr.getId().getVal(), o);
                } else if (repeatId != null) {
                    this.repeatSdtsByID.put(sdtPr.getId().getVal(), o);
                } else if (this.instanceCountOnly) {
                    String resultConditionId = map.get("od:resultConditionFalse");
                    String resultRepeatId = map.get("od:rptd");
                    String resultRptdZeroId = map.get("od:resultRepeatZero");
                    if (resultConditionId != null) {
                        this.conditionSdtsByID.put(sdtPr.getId().getVal(), o);
                    } else if (resultRptdZeroId != null) {
                        this.repeatSdtsByID.put(sdtPr.getId().getVal(), o);
                    } else if (resultRepeatId != null) {
                        this.repeatSdtsByID.put(sdtPr.getId().getVal(), o);
                    }
                }
            }
            return null;
        }

        @Override
        public boolean shouldTraverse(Object o) {
            return !(o instanceof SdtBlock) && !(o instanceof SdtRun) && !(o instanceof CTSdtRow) && !(o instanceof CTSdtCell);
        }
    }
}

