/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts;

import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.NamespacePrefixMappings;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.utils.XPathFactoryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XmlPart
extends Part {
    protected static Logger log = LoggerFactory.getLogger(XmlPart.class);
    protected Document doc;
    private static XPath xPath = XPathFactoryUtil.newXPath();
    private NamespacePrefixMappings nsContext;

    public XmlPart(PartName partName) throws InvalidFormatException {
        super(partName);
    }

    public XmlPart() throws InvalidFormatException {
    }

    private NamespacePrefixMappings getNamespaceContext() {
        if (this.nsContext == null) {
            this.nsContext = new NamespacePrefixMappings();
            xPath.setNamespaceContext(this.nsContext);
        }
        return this.nsContext;
    }

    public void setDocument(InputStream is) throws Docx4JException {
        try {
            DocumentBuilder documentBuilder = XmlUtils.getDocumentBuilderFactory().newDocumentBuilder();
            this.doc = documentBuilder.parse(is);
        }
        catch (Exception e) {
            throw new Docx4JException("Problems parsing InputStream for part " + this.partName.getName(), e);
        }
    }

    public void setDocument(Document doc) {
        this.doc = doc;
    }

    public abstract Document getDocument() throws Docx4JException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String xpathGetString(String xpathString, String prefixMappings) throws Docx4JException {
        try {
            String result;
            XPath xPath = XmlPart.xPath;
            synchronized (xPath) {
                this.getNamespaceContext();
                NamespacePrefixMappings.registerPrefixMappings(prefixMappings);
                result = XmlPart.xPath.evaluate(xpathString, this.doc);
            }
            if (result.equals("") && log.isWarnEnabled()) {
                NodeList nl = (NodeList)XmlPart.xPath.evaluate(xpathString, this.doc, XPathConstants.NODESET);
                if (nl.getLength() == 0) {
                    log.warn("No match for " + xpathString + " so result is empty string");
                } else {
                    log.debug(xpathString + " ---> '" + result + "'");
                }
            } else {
                log.debug(xpathString + " ---> '" + result + "'");
            }
            return result;
        }
        catch (Exception e) {
            throw new Docx4JException("Problems evaluating xpath '" + xpathString + "'", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Node> xpathGetNodes(String xpathString, String prefixMappings) {
        XPath xPath = XmlPart.xPath;
        synchronized (xPath) {
            this.getNamespaceContext();
            NamespacePrefixMappings.registerPrefixMappings(prefixMappings);
            return XmlUtils.xpath(this.doc, xpathString, this.getNamespaceContext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setNodeValueAtXPath(String xpath, String value, String prefixMappings) throws Docx4JException {
        try {
            Node n;
            XPath xPath = XmlPart.xPath;
            synchronized (xPath) {
                this.getNamespaceContext();
                NamespacePrefixMappings.registerPrefixMappings(prefixMappings);
                n = (Node)XmlPart.xPath.evaluate(xpath, this.doc, XPathConstants.NODE);
            }
            if (n == null) {
                log.debug("xpath returned null");
                return false;
            }
            log.debug(n.getClass().getName());
            if (n.getChildNodes() != null && n.getChildNodes().getLength() > 0) {
                NodeList nodes = n.getChildNodes();
                for (int i = nodes.getLength(); i > 0; --i) {
                    n.removeChild(nodes.item(i - 1));
                }
            }
            Text t = n.getOwnerDocument().createTextNode(value);
            n.appendChild(t);
            return true;
        }
        catch (Exception e) {
            throw new Docx4JException("Problem setting value at xpath " + xpath);
        }
    }

    @Override
    public boolean isContentEqual(Part other) throws Docx4JException {
        if (!(other instanceof XmlPart)) {
            return false;
        }
        Document doc1 = this.getDocument();
        Document doc2 = ((XmlPart)other).getDocument();
        return doc1.isEqualNode(doc2);
    }
}

