% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extractPkgName}
\alias{extractPkgName}
\alias{extractVersionNumber}
\alias{extractInequality}
\alias{extractPkgGitHub}
\alias{trimVersionNumber}
\title{Extract info from package character strings}
\usage{
extractPkgName(pkgs)

extractVersionNumber(pkgs)

extractInequality(pkgs)

extractPkgGitHub(pkgs)

trimVersionNumber(pkgs)
}
\arguments{
\item{pkgs}{A character string vector of packages with or without GitHub path or versions}
}
\value{
Just the package names without extraneous info.
}
\description{
Cleans a character vector of non-package name related information (e.g., version)
}
\examples{
extractPkgName("Require (>=0.0.1)")
extractVersionNumber("Require (<=0.0.1)")
extractInequality("Require (<=0.0.1)")
extractPkgGitHub("PredictiveEcology/Require")
trimVersionNumber("PredictiveEcology/Require (<=0.0.1)")
}
