% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuthBackendBearer.R
\name{AuthBackendBearer}
\alias{AuthBackendBearer}
\title{Bearer token authorization backend}
\description{
Creates AuthBackendBearer class object.
}
\examples{

token_db = list(
  "valid-token" = as.POSIXct("2099-12-31", tz = "GMT"),
  "expired-token" = as.POSIXct("1900-01-01", tz = "GMT")
)
auth_fun = function(token) {
  if (is.null(token_db[[token]])) return(FALSE) # not found
  if (Sys.time() > token_db[[token]]) return(FALSE) # expired
  return(TRUE)
}
# init backend
auth_backend = AuthBackendBearer$new(FUN = auth_fun)

# test backend
# define credentials (see RFC)
token = "valid-token"
# generate request headers
h = list("Authorization" = sprintf("Bearer \%s", token))
# simulate request
rq = Request$new(path = "/", headers = h)
# init response object
rs = Response$new()
# perform authentication
auth_backend$authenticate(rq, rs) # TRUE

}
\references{
\href{https://tools.ietf.org/html/rfc6750}{RFC6750}
\href{https://swagger.io/docs/specification/authentication/bearer-authentication}{Specification}
}
\seealso{
\link{AuthMiddleware} \link{Request} \link{Response}

Other AuthBackend: 
\code{\link{AuthBackendBasic}},
\code{\link{AuthBackend}},
\code{\link{AuthMiddleware}}
}
\concept{AuthBackend}
\section{Super class}{
\code{\link[RestRserve:AuthBackend]{RestRserve::AuthBackend}} -> \code{AuthBackendBearer}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{AuthBackendBearer$new()}}
\item \href{#method-authenticate}{\code{AuthBackendBearer$authenticate()}}
\item \href{#method-clone}{\code{AuthBackendBearer$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates AuthBackendBearer class object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AuthBackendBearer$new(FUN)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{FUN}}{Function to perform authentication which takes one arguments - \code{token}.
Returns boolean - whether access is allowed for a requested \code{token} or not.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-authenticate"></a>}}
\if{latex}{\out{\hypertarget{method-authenticate}{}}}
\subsection{Method \code{authenticate()}}{
Provide authentication for the given request.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AuthBackendBearer$authenticate(request, response)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{request}}{\link{Request} object.}

\item{\code{response}}{\link{Response} object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Boolean - whether access is allowed for a requested \code{user} or not.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AuthBackendBearer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
