% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMAP.R
\name{getMAP}
\alias{getMAP}
\title{get MAP}
\usage{
getMAP(var)
}
\arguments{
\item{var}{(numeric vector; no default) Vector of the samples from the
trace of a quantitative variable}
}
\value{
the MAP estimate
}
\description{
Calculates the Maximum a Posteriori estimate for the trace of a
quantitative variable
}
\details{
Uses the SANN method of the optim() function to approximate the MAP estimate
}
\examples{

\donttest{
# download the example dataset to working directory
url <-
  "https://revbayes.github.io/tutorials/intro/data/primates_cytb_GTR.log"
dest_path <- "primates_cytb_GTR.log"
download.file(url, dest_path)

# to run on your own data, change this to the path to your data file
file <- dest_path

trace <- readTrace(paths = file)
MAP <- getMAP(trace[[1]]$"pi[1]")

# remove file
# WARNING: only run for example dataset!
# otherwise you might delete your data!
file.remove(dest_path)
}

}
\seealso{
\link[stats]{optim}
}
