% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFBDTree.R
\name{plotFBDTree}
\alias{plotFBDTree}
\title{Plot FBD tree}
\usage{
plotFBDTree(
  tree,
  timeline = FALSE,
  geo = timeline,
  geo_units = list("epochs", "periods"),
  time_bars = timeline,
  node_age_bars = TRUE,
  tip_age_bars = TRUE,
  age_bars_color = "blue",
  age_bars_colored_by = NULL,
  node_labels = NULL,
  node_labels_color = "black",
  node_labels_size = 3,
  node_labels_offset = 0,
  tip_labels = TRUE,
  tip_labels_italics = TRUE,
  tip_labels_remove_underscore = TRUE,
  tip_labels_color = "black",
  tip_labels_size = 3,
  tip_labels_offset = 0,
  node_pp = FALSE,
  node_pp_shape = 16,
  node_pp_color = "black",
  node_pp_size = "variable",
  branch_color = "black",
  color_branch_by = NULL,
  line_width = 1,
  label_sampled_ancs = FALSE,
  ...
)
}
\arguments{
\item{tree}{(list of lists of treedata objects; no default) Name of a list
of lists of treedata objects, such as produced by readTrees(). This
object should only contain only one summary tree from one trace file. If it
contains multiple trees or multiple traces, only the first will be used.}

\item{timeline}{(logical; FALSE) Plot time tree with labeled x-axis with
timescale in MYA.
#'}

\item{geo}{(logical; timeline) Add a geological timeline? Defaults to the
same as timeline.}

\item{geo_units}{(list; list("epochs", "periods")) Which geological units to
include in the geo timescale.}

\item{time_bars}{(logical; timeline) Add vertical gray bars to indicate
geological timeline units if geo == TRUE or regular time intervals (in MYA)
if geo == FALSE.}

\item{node_age_bars}{(logical; TRUE) Plot time tree with node age bars?}

\item{tip_age_bars}{(logical; FALSE) Plot node age bars for the tips as
well? Useful for plotting serial sampled analyses or fossilized birth-death
analyses, or any cases where some tip ages are estimated.}

\item{age_bars_color}{(character; "blue") Color for node/tip age bars.
If age_bars_colored_by specifies a variable (not NULL), you must provide
two colors, low and high values for a gradient. Colors must be either R
valid color names or valid hex codes.}

\item{age_bars_colored_by}{(character; NULL) Specify column to color
node/tip age bars by, such as "posterior". If null, all age bars plotted the
same color, specified by age_bars_color}

\item{node_labels}{(character; NULL) Plot text labels at nodes, specified
by the name of the corresponding column in the tidytree object. If NULL,
no text is plotted.}

\item{node_labels_color}{(character; "black") Color to plot node_labels,
either as a valid R color name or a valid hex code.}

\item{node_labels_size}{(numeric; 3) Size of node labels}

\item{node_labels_offset}{(numeric; 0) Horizontal offset of node labels
from nodes.}

\item{tip_labels}{(logical; TRUE) Plot tip labels?}

\item{tip_labels_italics}{(logical; TRUE) Plot tip labels in italics?}

\item{tip_labels_remove_underscore}{(logical; FALSE) Should underscores be
replaced by spaces in tip labels?}

\item{tip_labels_color}{(character; "black") Color to plot tip labels,
either as a valid R color name or a valid hex code.}

\item{tip_labels_size}{(numeric; 3) Size of tip labels}

\item{tip_labels_offset}{(numeric; 1) Horizontal offset of tip labels from
tree.}

\item{node_pp}{(logical; FALSE) Plot posterior probabilities as symbols at
nodes? Specify symbol aesthetics with node_pp_shape, node_pp_color, and
node_pp_size.}

\item{node_pp_shape}{(integer; 1) Integer corresponding to point shape
(value between 0-25). See ggplot2 documentation for details:
\url{https://ggplot2.tidyverse.org/articles/ggplot2-specs.html#point}}

\item{node_pp_color}{(character; "black") Color for node_pp symbols, either
as valid R color name(s) or hex code(s). Can be a single character string
specifying a single color, or a vector of length two specifying two colors
to form a gradient. In this case, posterior probabilities will be indicated
by color along the specified gradient.}

\item{node_pp_size}{(numeric or character; 1) Size for node_pp symbols.
If numeric, the size will be fixed at the specified value. If a character,
it should specify "variable", indicating that size should be scaled by the
posterior value. Size regulates the area of the shape,
following ggplot2 best practices:
\url{https://ggplot2.tidyverse.org/reference/scale_size.html})}

\item{branch_color}{(character; "black") A single character string
specifying the color (R color name or hex code) for all branches OR a
vector of length 2 specifying two colors for a gradient, used to color the
branches according to the variable specified in color_branch_by. If only 1
color is provided and you specify color_branch_by, default colors will be
chosen (low = "#005ac8", high = "#fa7850").}

\item{color_branch_by}{(character; NULL ) Optional name of one quantitative
variable in the treedata object to color branches, such as a rate.}

\item{line_width}{(numeric; 1) Change line width for branches}

\item{label_sampled_ancs}{(logical; FALSE) Label any sampled ancestors?
Will inherent tip labels aesthetics for size and color.}

\item{...}{(various) Additional arguments passed to ggtree::ggtree().}
}
\value{
returns a single plot object.
}
\description{
Plots a single FBD tree, such as an MCC or MAP tree.
}
\details{
Plots a single tree, such as an MCC or MAP tree, with
special features for plotting the output of fossilized
birth-death analyses.
}
\examples{
\donttest{
file <- system.file("extdata", "fbd/bears.mcc.tre", package="RevGadgets")
tree <- readTrees(paths = file)
plotFBDTree(tree = tree, timeline = TRUE, tip_labels_italics = FALSE,
            tip_labels_remove_underscore = TRUE,
            node_age_bars = TRUE, age_bars_colored_by = "posterior",
            age_bars_color = rev(colFun(2))) +
  ggplot2::theme(legend.position=c(.25, .85))
}
}
