% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_data_model_detection.R
\name{mod_data_model_detection}
\alias{mod_data_model_detection}
\alias{data_model_detection_ui}
\alias{patient_chart_ui}
\alias{data_model_detection_server}
\title{Data Model Detection Module}
\usage{
data_model_detection_ui(id)

patient_chart_ui(id)

data_model_detection_server(id, database_vars, navigation_vars, parent_session)
}
\arguments{
\item{id}{The Module namespace}

\item{database_vars}{A reactiveValues object as returned by \link[ReviewR]{mod_database_setup}.}

\item{navigation_vars}{A reactiveValues object as returned by \link[ReviewR]{mod_navigation}.}

\item{parent_session}{The session information from the parent environment of this module.}
}
\value{
\emph{data_model_detection_ui}:
\item{tagList}{A uiOutput describing the detected data model and version.}
\emph{patient_chart_ui}:
\item{tagList}{The "Patient Chart" on the "Chart Review" tab of ReviewR.}
\emph{data_model_detection_server}:
\item{reactiveValues}{
\itemize{
\item{\emph{table_map}}: A tibble containing a mapping between the CDM standard
tables and fields to the user connected tables and fields.
\item{\emph{message}}: A character vector containing the message describing the
detected data model and version.
\item{\emph{table_functions}}: A tibble containing the table function names for
the detected data model as well as the table names which the functions will
create.
\item{\emph{all_patients_table}}: A tibble containing \emph{only} the "All Patients"
function and table name. Used to render the "All Patients" table on the
"Patient Search" tab.
\item{\emph{subject_tables}}: A tibble containing the "Subject Specific"
functions and table names. Used to render the patient chart tabsets on
the "Chart Review" tab.
}}
}
\description{
This module will interrogate a user connected database, comparing it with
known common data models to determine the both the data model and version
(when applicable) of the user's database.

It informs the rest of the application how to interpret and display the data
stored in the connected database, when possible. If an unsupported data model
is detected, the user is informed and given the opportunity to connect to
a different database.

This module consists of the following components:
\subsection{Module UI functions}{

These functions return a Shiny \code{tagList} containing various UI elements of the
ReviewR application. UI components are calculated by the
\code{data_model_detection_server} function of this module.
\itemize{
\item{\code{data_model_detection_ui}}: A server defined uiOutput
describing the detected data model and version.
\item{\code{patient_chart_ui}}: The "Patient Chart," with the appropriate display
elements based on the detected data model. Appears on the "Chart Review" tab
of ReviewR.
}
}

\subsection{Module Server function}{

The server function of this module is responsible for calculating the display
elements included in the UI functions of this module as well as returning a
reactiveValues object containing various other objects used by other modules.
\itemize{
\item{\code{data_model_detection_server}}: Contains the data model detection logic
and calculates UI elements. Returns a reactiveValues object containing variables
used in other modules.
}
}
}
\keyword{internal}
