% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_layout_chartreview.R
\name{mod_layout_chartreview}
\alias{mod_layout_chartreview}
\alias{chartreview_ui}
\alias{chartreview_server}
\title{Chart Review Interface Module}
\usage{
chartreview_ui(id)

chartreview_server(id, database_vars, abstract_vars)
}
\arguments{
\item{id}{The module namespace}

\item{database_vars}{A reactiveValues object as returned by \link[ReviewR]{mod_database_setup}.}

\item{abstract_vars}{A reactiveValues object as returned by \link[ReviewR]{mod_abstraction_setup}.}
}
\value{
\emph{chartreview_ui}:
\item{tagList}{The Chart Review UI}
\emph{chartreview_server}:
\item{}{This function has no return, other than creating a UI output for the
UI function of this module.}
}
\description{
This module determines if "View" or "Review" interface is needed based on presence
or absence of a configured abstraction module. When an abstraction module
is configured on the "Setup" tab of ReviewR, a column will be created to the
right of the patient chart for the abstraction data collection instrument.
Otherwise, the patient chart will take up the full view.

This module consists of the following components:
\subsection{Module UI function}{

\itemize{
\item{\code{chartreview_ui}}: A uiOutput containing the View or Review
interface
}
}

\subsection{Module Server function}{

\itemize{
\item{\code{chartreview_server}}: The logic that controls the layout
of the "Chart Review" tab in ReviewR. "View" if no abstraction module
is configured. "Review" if abstraction module configured.
}
}
}
\keyword{internal}
