% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/getInsights.R
\name{getInsights}
\alias{getInsights}
\title{Extract Insights metric from a Facebook page (admin role required)}
\usage{
getInsights(object_id, token, metric, period = "day", parms = NA,
  version = 2.3, n = 5)
}
\arguments{
\item{object_id}{An object (page, post, domain) ID.}

\item{token}{Either a temporary access token created at
\url{https://developers.facebook.com/tools/explorer} or the OAuth token
created with \code{fbOAuth}.}

\item{metric}{The metric(s) which you want to get values for.}

\item{period}{Time intervals to return}

\item{parms}{Optional argument that can be used to append additional
parameters. For example, \code{&since=DATE&until=DATE}.}

\item{version}{specifies what API version to use in the request. Version 2.5 is default.}

\item{n}{Number of time intervals of metric values to return. Note that all
metrics returned will be multiple of 3, except for lifetime period. Default
n is 5}
}
\description{
\code{getInsights} retrieves information from an owned Facebook page. Note
that you must specify wich metric from insights you need and the period.
To request multiple metrics at one time, pass a vector of metric names with a vector
of periods of the same length. If only one period is supplied, it will apply to each metric.
Please refer to Facebook's documentation for valid combinations of objects, metrics and periods.
}
\details{
The current list of supported metrics and periods is: page_fan_adds, page_fan_removes,
page_views_login, page_views_login, page_views_logout, page_views, page_story_adds,
page_impressions, page_posts_impressions, page_consumptions, post_consumptions_by_type,
page_consumptions, and page_fans_country.

For more information, see: \url{https://developers.facebook.com/docs/graph-api/reference/v2.5/insights}
}
\examples{
\dontrun{
## See examples for fbOAuth to know how token was created.
## Getting page impressions for Facebook's Facebook Page
## (only owner or admin of page)
 load("fb_oauth")
	insights <- getInsights(object_id="20531316728", token=fb_oauth, metric='page_impressions')
## Getting post impressions for a random Facebook's page post
## (only owner or admin of page)
 insights <- getInsights(object_id='221568044327801_754789777921289',
     token=fb_oauth, metric='post_impressions', period='days_28')
## Getting page fans for date range
## (only owner or admin of page)
insights <- getInsights(object_id='221568044327801',
    token=fb_oauth, metric=c'page_fans', period='lifetime',
    parms='&since=2015-01-01&until=2015-01-31', version=2.5)
#' ## Getting page fans AND page impressions for date range
## (only owner or admin of page)
insights <- getInsights(object_id='221568044327801',
    token=fb_oauth, metric=c('page_fans','page_impressions'), period=c('lifetime','day'),
    parms='&since=2015-01-01&until=2015-01-31')
## Count of fans by country
  insights <- getInsights(object_id='221568044327801_754789777921289',
     token=fb_oauth, metric='page_fans_country', period='lifetime')
}
}
\author{
Danilo Silva \email{silvadaniloc@gmail.com}
Eduardo Carvalho \email{eduardooc.86@gmail.com}
Andrew Geisler \url{https://github.com/andrewgeisler}
}

